/**
 * 
 */
package com.pcloud.book.book.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.biz.BookTypeBiz;
import com.pcloud.book.book.dao.BookTypeDao;
import com.pcloud.book.book.dto.BookTypeDto;
import com.pcloud.book.book.set.BookSet;
import com.pcloud.common.exceptions.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2017年1月3日,下午3:11:17
 * @版本：1.0
 */
@Service("bookTypeBiz")
public class BookTypeBizImpl implements BookTypeBiz {

	/**
	 * 
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(BookTypeBizImpl.class);
	
	@Autowired
	private BookTypeDao bookTypeDao;
	@Autowired
	private BookSet bookSet;
	
	/**
	 * 获取书籍类型列表
	 */
	@Override
	public List<BookTypeDto> getList() throws BizException {
		try {
			return bookTypeDao.getList();
		} catch (Exception e) {
			LOGGER.error("【书籍-类型-编辑】获取书籍类型列表,<ERROR>.[bookDao.insert]" + e.getMessage(), e);
			throw new BookBizException(BookBizException.DB_DML_FAIL, "获取书籍类型列表失败~！");
		}	
	}
	
	/**
	 * 图书和期刊占比
	 */
	@Override
	public List<BookTypeDto> getPercent4Type(Long adviserId) throws BizException {
		try {
			LOGGER.info("【书籍-类型-编辑】获取图书和期刊占比,<START>adviserId:{}", adviserId);
			List<BookTypeDto> bookTypes = bookTypeDao.getPercent4Type(adviserId);
			bookSet.setPercent(bookTypes);
			return bookTypes;
		} catch (Exception e) {
			LOGGER.error("【书籍-类型-编辑】获取图书和期刊占比,<ERROR>.[bookDao.insert]" + e.getMessage(), e);
			throw new BookBizException(BookBizException.DB_DML_FAIL, "获取图书和期刊占比失败~！");
		}
	}

}
