package com.pcloud.book.book.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 出版社做书数据列表明细
 *
 * @author guiq
 * @version 1.0
 * @since 2020年9月24日
 */
@Data
@ApiModel("出版社做书数据列表明细")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AgentBookStatsDetailVO implements Serializable {

    private static final long serialVersionUID = 9125134175050870278L;

    /**
     * 书名
     */
    @ApiModelProperty("书名")
    private String bookName;

    /**
     * ISBN
     */
    @ApiModelProperty("ISBN")
    private String isbn;

    /**
     * 序号
     */
    @ApiModelProperty("序号")
    private String serialNumber;

    /**
     * ERP编号
     */
    @ApiModelProperty("ERP编号")
    private String erpNumber;

    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    private String projectNumber;

    /**
     * 图书ID
     */
    @ApiModelProperty("图书ID")
    private Long bookId;

    /**
     * 二维码列表
     */
    @ApiModelProperty("二维码列表")
    private List<QrcodeInfoDto> qrcodeList;

    /**
     * 编辑名称
     */
    @ApiModelProperty("编辑名称")
    private String adviserName;

    /**
     * 编辑ID
     */
    @ApiModelProperty("编辑ID")
    private Long adviserId;

    /**
     * 是否小睿书
     */
    @ApiModelProperty("是否小睿书")
    private Integer isRay;

    /**
     * 立项时间
     */
    @ApiModelProperty("立项时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date toProjectTime;

    /**
     * 印册量
     */
    @ApiModelProperty("印册量")
    private Integer expectPublishNum;

    /**
     * 总浏览量
     */
    @ApiModelProperty("总浏览量")
    private Integer browseTotal;

    /**
     * 总浏览人数
     */
    @ApiModelProperty("总浏览人数")
    private Integer browseUserTotal;

    /**
     * 总扫码量
     */
    @ApiModelProperty("总扫码量")
    private Integer scanTotal;

    /**
     * 总扫码人数
     */
    @ApiModelProperty("总扫码人数")
    private Integer scanUserTotal;

    /**
     * 总成交金额
     */
    @ApiModelProperty("总成交金额")
    private BigDecimal amountTotal;

    /**
     * bookAdviserId
     */
    @ApiModelProperty("bookAdviserId")
    private Long bookAdviserId;

    /**
     * channelId
     */
    @ApiModelProperty("channelId")
    private Long channelId;

    /**
     * bookGroupId
     */
    @ApiModelProperty("bookGroupId")
    private Long bookGroupId;
}
