/**
 * 
 */
package com.pcloud.book.consumer.channel;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.channelcenter.qrcode.dto.BookDto;
import com.pcloud.channelcenter.qrcode.dto.GroupQrcodeVO;
import com.pcloud.channelcenter.qrcode.dto.QrcodeSceneDto;
import com.pcloud.channelcenter.qrcode.entity.QrcodeScene;
import com.pcloud.channelcenter.qrcode.service.QrcodeSceneService;
import com.pcloud.channelcenter.qrcode.vo.BookAssocLastQrAskVO;
import com.pcloud.channelcenter.qrcode.vo.BookAssocLastQrVO;
import com.pcloud.channelcenter.qrcode.vo.BookAssocQRcountRequestVO;
import com.pcloud.channelcenter.wechat.dto.AccountSettingDto;
import com.pcloud.channelcenter.wechat.dto.AdviserBookResourceNumReqDTO;
import com.pcloud.channelcenter.wechat.dto.AdviserBookResourceNumRespDTO;
import com.pcloud.channelcenter.wechat.dto.BookServeParamVO;
import com.pcloud.channelcenter.wechat.dto.ListIsInBookParam;
import com.pcloud.channelcenter.wechat.service.AccountSettingService;
import com.pcloud.channelcenter.wechat.service.MessageService;
import com.pcloud.channelcenter.wechat.vo.BookServeVO;
import com.pcloud.channelcenter.qrcode.dto.AppTypeUseCount;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.channelcenter.wechat.entity.SpecialUser;

import org.apache.regexp.RE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：二维码中间件
 * @作者：songx
 * @创建时间：2016年12月14日,下午5:36:04 @版本：1.0
 */
@Component("qrcodeSceneConsr")
public class QrcodeSceneConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(QrcodeSceneConsr.class);

	@Autowired
	private QrcodeSceneService qrcodeSceneService;
	@Autowired
	private MessageService messageService;
	@Autowired
	private AccountSettingService accountSettingService;



	/**
	 * 删除书籍关联的二维码
	 */
	public void deleteBook(Long bookId, Long channelId, Long adviserId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】删除书籍关联的二维码,<PARAM>.[bookId]=" + bookId+"channelId="+channelId+"adviserId="+adviserId);
		if (bookId == null) {
			throw new BookBizException(BookBizException.PARAM_IS_NULL, "书籍标识不能为空~!");
		}
		try {
			qrcodeSceneService.deleteBook(bookId, channelId, adviserId);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】删除书籍关联的二维码关联关系,<ERROR>.[qrcodeSceneService.deleteBook]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】删除书籍关联的二维码关联关系,<ERROR>.[qrcodeSceneService.deleteBook]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "批量删除书籍关联的二维码关联关系失败~!");
		}
	}

	/**
	 * 获取书籍对应二维码关系
	 */
	public Map<String, Object> getQr4Book(Long bookId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】 获取书籍对应二维码关系,<PARAM>.[bookId]=" + bookId);
		Map<String, Object> result = null;
		try {
			ResponseEntity<ResponseDto<Map<String, Object>>> qr4Book = qrcodeSceneService.getQr4Book(bookId);
			result = ResponseHandleUtil.parseMap(qr4Book, String.class, Object.class);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 获取书籍对应二维码关系,<ERROR>.[qrcodeSceneService.getQr4Book]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 获取书籍对应二维码关系,<ERROR>.[qrcodeSceneService.getQr4Book]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "获取书籍对应二维码关系失败~!");
		}
		return result;
	}

	/**
	 * 获取书籍对应二维码关系
	 */
	public List<Long> getAliQrByBookId(Long bookId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】 获取书籍对应二维码关系,<PARAM>.[bookId]=" + bookId);
		List<Long> result = null;
		try {
			ResponseEntity<ResponseDto<List<Long>>> qr4Book = qrcodeSceneService.getAliQrByBookId(bookId);
			result = ResponseHandleUtil.parseList(qr4Book,Long.class);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 获取书籍对应二维码关系,<ERROR>.[qrcodeSceneService.getQr4Book]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 获取书籍对应二维码关系,<ERROR>.[qrcodeSceneService.getQr4Book]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "获取书籍对应二维码关系失败~!");
		}
		return result;
	}

	/**
	 * 删除编辑二维码关联关系
	 */
	public void deleteAdviserBookQrRelation(Long adviserId, Long bookId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】删除编辑二维码关联关系,<PARAM>.[adviserId]=" + adviserId + ",[bookId]=" + bookId);
		if (bookId == null) {
			LOGGER.error("【二维码-渠道(消)】删除编辑二维码关联关系,<PARAM=NULL>");
			throw new BookBizException(BookBizException.PARAM_IS_NULL, "编辑标识和书籍标识不能为空~!");
		}

		try {
			qrcodeSceneService.deleteAdviserBookQrRelation(adviserId, bookId);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】删除编辑二维码关联关系,<ERROR>.[qrcodeSceneService.deleteBook]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】删除编辑二维码关联关系,<ERROR>.[qrcodeSceneService.deleteBook]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "删除编辑二维码关联关系失败~!");
		}
	}

	/**
	 * 获取书籍二维码个数
	 */
	public Map<String, Long> listBookQrCount(List<Long> bookIds, List<Long> channelIds, Long adviserId)
			throws BizException {
		LOGGER.info("【二维码-渠道(消)】获取书籍二维码个数,<START>.[bookIds]=" + bookIds + ",[channelIds]=" + channelIds
				+ ",[adviserId]=" + adviserId);
		Map<String, Long> bookQrCount = new HashMap<>();
		if (ListUtils.isEmpty(bookIds) || ListUtils.isEmpty(channelIds) || adviserId == null) {
			return bookQrCount;
		}
		try {
			Map<String, Object> idsMap = new HashMap<>();
			idsMap.put("bookIds", bookIds);
			idsMap.put("channelIds", channelIds);
			ResponseEntity<ResponseDto<Map<String, Long>>> listBookQrCount = qrcodeSceneService.listBookQrCount(idsMap,
					adviserId);
			bookQrCount = ResponseHandleUtil.parseMap(listBookQrCount, String.class, Long.class);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】获取书籍二维码个数,<ERROR>.[qrcodeSceneService.deleteBook]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】获取书籍二维码个数,<ERROR>.:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "获取书籍二维码个数失败~!");
		}
		return bookQrCount;
	}

	/**
	 * 根据图书删除二维码
	 */
	public void deleteByBook(Long bookId, Long channelId, Long adviserId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】根据图书删除二维码,<START>.[bookId]=" + bookId + ",[channelId]=" + channelId + "[adviserId]="
				+ adviserId);
		if (bookId == null || channelId == null) {
			return;
		}
		try {
			qrcodeSceneService.deleteByBook(bookId, channelId, adviserId);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 根据图书删除二维码[qrcodeSceneService.deleteByBook]失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 根据图书删除二维码[qrcodeSceneService.deleteByBook],<ERROR>.[create]:" + e.getMessage(),
					e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, " 根据图书删除二维码失败~!");
		}
	}

	/**
	 * 根据图书恢复二维码
	 */
	public void recoverByBook(Long bookId, Long channelId, Long adviserId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】根据图书恢复二维码,<START>.[bookId]=" + bookId + ",[channelId]=" + channelId + "[adviserId]="
				+ adviserId);
		if (bookId == null || channelId == null) {
			return;
		}
		try {
			qrcodeSceneService.recoverByBook(bookId, channelId, adviserId);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 根据图书恢复二维码[qrcodeSceneService.recoverByBook]失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 根据图书恢复二维码[qrcodeSceneService.recoverByBook],<ERROR>.[create]:" + e.getMessage(),
					e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, " 根据图书恢复二维码失败~!");
		}
	}

	/**
	 * 获取图书待审核二维码
	 */
	public Map<Long, Long> getCountMapByBookIds(List<Long> bookIds) throws BizException {
		LOGGER.info("【二维码-渠道(消)】获取图书待审核二维码,<START>.[bookIds]=" + bookIds);
		if (ListUtils.isEmpty(bookIds)) {
			return null;
		}
		Map<Long, Long> result = null;
		try {
			result = ResponseHandleUtil.parseMapResponse(qrcodeSceneService.getCountMapByBookIds(bookIds),Long.class,Long.class);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 获取图书待审核二维码[qrcodeSceneService.getCountMapByBookIds]失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 获取图书待审核二维码[qrcodeSceneService.getCountMapByBookIds],<ERROR>.[create]:" + e.getMessage(),
					e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, " 获取图书待审核二维码失败~!");
		}
		return result;
	}

	/**
	 * 获取图书最近关联二维码信息
	 */
	public Map<String, BookAssocLastQrVO> getLastQrInfoByBookIds(List<BookAssocLastQrAskVO> bookAssocLastQrAskVOs) throws BizException {
		LOGGER.info("【二维码-渠道(消)】获取图书最近关联二维码信息,<START>.[bookAssocLastQrAskVOs]=" + bookAssocLastQrAskVOs);
		if (ListUtils.isEmpty(bookAssocLastQrAskVOs)) {
			return null;
		}
		Map<String, BookAssocLastQrVO> result = null;
		try {
			result = ResponseHandleUtil.parseMapResponse(qrcodeSceneService.getLastQrInfoByBookIds(bookAssocLastQrAskVOs),String.class,BookAssocLastQrVO.class);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 获取图书最近关联二维码信息[qrcodeSceneService.getLastQrInfoByBookIds]失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 获取图书最近关联二维码信息[qrcodeSceneService.getLastQrInfoByBookIds],<ERROR>.[create]:" + e.getMessage(),
					e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, " 获取图书最近关联二维码信息失败~!");
		}
		return result;
	}

	@ParamLog(description = "获取图书关联二维码个数")
	public Integer getBookQRCountByMap(Long adviserId,Long channelId,Long bookId)throws BizException{
		Integer count = 0;
		BookAssocQRcountRequestVO bookAssocQRcountRequestVO = new BookAssocQRcountRequestVO();
		bookAssocQRcountRequestVO.setAdviserId(adviserId);
		bookAssocQRcountRequestVO.setBookId(bookId);
		bookAssocQRcountRequestVO.setChannelId(channelId);
		try {
			count = ResponseHandleUtil.parseResponse(qrcodeSceneService.getBookQRCountByMap(bookAssocQRcountRequestVO),Integer.class);
		} catch (BizException e) {
			LOGGER.error("【二维码-渠道(消)】 获取图书关联二维码个数[qrcodeSceneService.getBookQRCountByMap],<ERROR>.[create]:" + e.getMessage(),
					e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, " 获取图书关联二维码个数失败~!");
		}
		return count;
	}


	@ParamLog(description = "获取二维码基本信息")
	public QrcodeSceneDto getById(Long sceneId) throws BizException {
		if(sceneId == null) return null;
		try {
			return ResponseHandleUtil.parseResponse(qrcodeSceneService.getById(sceneId), QrcodeSceneDto.class);
		} catch (BizException e) {
			LOGGER.error("【二维码-渠道(消)】 获取二维码基本信息失败,<ERROR>.[getById]:" + e.getMessage(),
					e);
		}
		return null;
	}


	public Map<String, Boolean> listIsInBook(Long bookId, Long channelId, Long adviserId, List<Long> serveIds) throws BizException {
		if (bookId == null || channelId == null || adviserId == null || ListUtils.isEmpty(serveIds)) return null;
		try {
			ListIsInBookParam listIsInBookParam = new ListIsInBookParam();
			listIsInBookParam.setAdviserId(adviserId);
			listIsInBookParam.setBookId(bookId);
			listIsInBookParam.setChannelId(channelId);
			listIsInBookParam.setServeIds(serveIds);
			return ResponseHandleUtil.parseMap(messageService.listIsInBook(listIsInBookParam), String.class, Boolean.class);
		} catch (BizException e) {
			LOGGER.error("【二维码-渠道(消)】获取是否是图书下的服务失败,<ERROR>.[listIsInBook]:" + e.getMessage(),
					e);
		}
		return null;
	}

	@ParamLog(description = "获取公众号基本信息")
	public AccountSettingDto getWechatInfo(Long channelId) throws BizException {
		if (channelId == null) return null;
		AccountSettingDto accountSettingDto = null;
		try {
			accountSettingDto = ResponseHandleUtil.parseResponse(accountSettingService.getWechat(channelId, SystemCode.channel.code), AccountSettingDto.class);
		} catch (BizException e) {
			LOGGER.error("【渠道(消)】 获取公众号基本信息,<ERROR>.[getById]:" + e.getMessage(), e);
		}
		return accountSettingDto;
	}


	@ParamLog(description = "将二维码替换为微信群二维码")
	public GroupQrcodeVO setQrcodeToGroup(Long sceneId) throws BizException {
		if (sceneId == null) return null;
		try {
			return ResponseHandleUtil.parseResponse(qrcodeSceneService.setQrcodeToGroup(sceneId), GroupQrcodeVO.class);
		} catch (BizException e) {
			LOGGER.error("【渠道(消)】 将二维码替换为微信群二维码,<ERROR>.[setQrcodeToGroup]:" + e.getMessage(), e);
		}
		return null;
	}

	@ParamLog(description = "公众号二维码生成微信群二维码")
	public GroupQrcodeVO createWxGroupQrcode(Long bookId, Long channelId, Long adviserId) throws BizException {
		if (bookId == null ||channelId == null || adviserId == null) return null;
		try {
			return ResponseHandleUtil.parseResponse(qrcodeSceneService.createWxGroupQrcode(channelId, adviserId, bookId), GroupQrcodeVO.class);
		} catch (BizException e) {
			LOGGER.error("【渠道(消)】 公众号二维码生成微信群二维码,<ERROR>.[createWxGroupQrcode]:" + e.getMessage(), e);
		}
		return null;
	}

	@ParamLog("根据二维码id获取bookId")
	public Long getBookId4SceneId(Long sceneId) throws BizException {
		if (null == sceneId) return null;
		try {
			return ResponseHandleUtil.parseResponse(qrcodeSceneService.getBookId4SceneId(sceneId), Long.class);

		} catch (BizException e) {
			LOGGER.error("【二维码-渠道】 根据二维码id获取bookId,<ERROR>.[getBookId4SceneId]:" + e.getMessage(), e);
		}
		return null;
	}

	@ParamLog("获取编辑下有二维码的图书")
	public List<BookDto> getQrcodeBookIds(List<Long> channelIds, Long adviserId) {
		List<BookDto> bookIds = new ArrayList<>();
		try {
			bookIds = ResponseHandleUtil.parseListResponse(qrcodeSceneService.getQrcodeBookIds(channelIds, adviserId), BookDto.class);

		} catch (Exception e) {
			LOGGER.error("【二维码-渠道】 获取编辑下有二维码的图书,<ERROR>.[getQrcodeBookIds]:" + e.getMessage(), e);
		}
		return bookIds;
	}

	//删除二维码
	public void updateQrcodeToSelfRobotQrcode(Long sceneId, Long adviserBookId) {
		try {
			qrcodeSceneService.updateQrcodeToSelfRobotQrcode(sceneId, adviserBookId);
		} catch (Exception e) {
			LOGGER.error("删除二维码失败" + e.getMessage(), e);
		}
	}

	@ParamLog("获取书刊下所有服务-书刊特配资源")
	public List<BookServeVO> listBookServe(BookServeParamVO bookServeParamVO){
		List<BookServeVO> list = new ArrayList<>();
		try {
			list = ResponseHandleUtil.parseList(messageService.listBookServe(bookServeParamVO),BookServeVO.class);

		}catch (Exception e){
			LOGGER.error("调用messageService.listBookServe失败" + e.getMessage(), e);
		}
		return list;
	}

	@ParamLog("获取书刊下所有服务id")
	public List<BookServeVO> listBookServeIds(BookServeParamVO bookServeParamVO){
		List<BookServeVO> list = new ArrayList<>();
		try {
			list = ResponseHandleUtil.parseList(messageService.listBookServeIds(bookServeParamVO),BookServeVO.class);

		}catch (Exception e){
			LOGGER.error("调用messageService.listBookServeIds失败" + e.getMessage(), e);
		}
		return list;
	}

	@ParamLog("小程序书刊资源数量")
	public Map<String, Integer> mapServeCount4Applet(List<Long> bookIds) {
		Map<String, Integer> map = new HashMap<>();
		try {
			map = ResponseHandleUtil.parseMapResponse(messageService.mapServeCount4Applet(bookIds), String.class, Integer.class);

		} catch (Exception e) {
			LOGGER.error("调用messageService.mapServeCount4Applet失败" + e.getMessage(), e);
		}
		return map;
	}

    public List<QrcodeSceneDto> getQrCodeList(Long bookId, Long adviserId, Long channelId) {
		List<QrcodeSceneDto> qrcodeSceneDtos = new ArrayList<>();
		try {
			qrcodeSceneDtos = ResponseHandleUtil.parseList(qrcodeSceneService.getQrCodeList(adviserId, bookId, channelId),QrcodeSceneDto.class);
		}catch (Exception e){
			LOGGER.error("调用qrcodeSceneService.getQrCodeList失败" + e.getMessage(), e);
		}
		return qrcodeSceneDtos;
    }

	public List<SpecialUser> getAllSpcialUser() {
		List<SpecialUser> specialUsers = null;
		try {
			specialUsers = ResponseHandleUtil.parseList(messageService.getAllSpecialUser(), SpecialUser.class);
		} catch (Exception e) {
			LOGGER.error("调用messageService.mapServeCount4Applet失败" + e.getMessage(), e);
		}
		return specialUsers;
	}

	@ParamLog("根据出版社获取小程序公众号id")
	public Long getAccountSettingIdByAgentId(Long agentId) {
		Long accountSettingId = null;
		try {
			accountSettingId = ResponseHandleUtil.parseResponse(accountSettingService.getAccountSettingIdByAgentId(agentId),Long.class);

		}catch (Exception e){
			LOGGER.error("根据出版社获取小程序公众号id失败" + e.getMessage(),e);
		}
		return  accountSettingId;
	}

	@ParamLog("小程序书刊资源数量")
	public Long createQrcodeScene4Erp(QrcodeScene qrcodeScene) {
		return ResponseHandleUtil.parseResponse(qrcodeSceneService.createQrcodeScene4Erp(qrcodeScene), Long.class);
	}

	@ParamLog("根据url获取二维码信息")
	public QrcodeSceneDto getByUrl(String url) {
		if(url == null) return null;
		try {
			return ResponseHandleUtil.parseResponse(qrcodeSceneService.getByUrl(url), QrcodeSceneDto.class);
		} catch (BizException e) {
			LOGGER.error("【二维码-渠道(消)】 获取二维码基本信息失败,<ERROR>.[getById]:" + e.getMessage(), e);
		}
		return null;
	}

	@ParamLog("获取图书下的资源数量")
	public List<AdviserBookResourceNumRespDTO> listResourceNum4AdviserBook(List<Long> adviserIds, List<Long> channelIds, List<Long> bookIds) {
		List<AdviserBookResourceNumRespDTO> list = new ArrayList<>();
		try {
			AdviserBookResourceNumReqDTO reqDTO = new AdviserBookResourceNumReqDTO();
			reqDTO.setAdviserIds(adviserIds);
			reqDTO.setBookIds(bookIds);
			reqDTO.setChannelIds(channelIds);
			list = ResponseHandleUtil.parseList(messageService.listResourceNum4AdviserBook(reqDTO), AdviserBookResourceNumRespDTO.class);
		} catch (Exception e) {
			LOGGER.error("【获取图书下的资源数量】 请求失败,<ERROR>.[listResourceNum4AdviserBook]:{}", e.getMessage(), e);
		}
		return list;
	}

	@ParamLog("获取公众号码热门应用")
	public List<AppTypeUseCount> listAppTypeCount(){
		List<AppTypeUseCount> list = new ArrayList<>();
		try{
			list = ResponseHandleUtil.parseList(qrcodeSceneService.listAppTypeCount(), AppTypeUseCount.class);
		}catch (Exception e){
			LOGGER.error("【获取公众号码热门应用】 请求失败,<ERROR>.[listAppTypeCount]:{}", e.getMessage(), e);
		}
		return list;
	}

	@ParamLog("根据条件获取书刊下所有服务id")
	public List<BookServeVO> listBookServeIdsByType(BookServeParamVO bookServeParamVO){
		List<BookServeVO> list = new ArrayList<>();
		try {
			list = ResponseHandleUtil.parseList(messageService.listBookServeIdsByType(bookServeParamVO),BookServeVO.class);

		}catch (Exception e){
			LOGGER.error("调用messageService.listBookServeIdsByType失败" + e.getMessage(), e);
		}
		return list;
	}
}
