package com.pcloud.book.consumer.settlement;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.settlementcenter.record.dto.AgentBookIncomeDTO;
import com.pcloud.settlementcenter.record.dto.AgentBookIncomeParamDTO;
import com.pcloud.settlementcenter.record.dto.AgentBookIncomeParamListDTO;
import com.pcloud.settlementcenter.record.dto.AllBookIncomeParamDTO;
import com.pcloud.settlementcenter.record.dto.ProductStaticUnderAppMapDTO;
import com.pcloud.settlementcenter.record.dto.ResourcesStatisticVO;
import com.pcloud.settlementcenter.record.service.BookService;
import com.pcloud.settlementcenter.record.service.SettlementService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("settlementConsr")
public class SettlementConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(SettlementConsr.class);

   @Autowired
	private SettlementService settlementService;
   @Autowired
   private BookService bookService;

	@ParamLog(value = "获取收益", isBefore = false, isAfterReturn = false)
	public Map<Long, BigDecimal> getWXGroupQrcodeIncomeByAdviser(List<Long> groupQrcodeIds, Long adviserId) throws BizException {
		if (ListUtils.isEmpty(groupQrcodeIds) || adviserId == null) {
			return null;
		}
		try {
			return ResponseHandleUtil.parseMapResponse(settlementService.getWXGroupQrcodeIncomeByAdviser(groupQrcodeIds, adviserId), Long.class, BigDecimal.class);
		} catch (Exception e) {
			LOGGER.error("获取收益.[getWXGroupQrcodeIncomeByAdviser]:" + e.getMessage(), e);
		}
		return null;
	}

	@ParamLog(value = "根据条件获取收益", isBefore = false, isAfterReturn = false)
	public Map<Long, BigDecimal> getAdviserIncomeByCondition(List<Long> ids, String type, Long partyId, Long groupQrcodeId, Long bookGroupId) throws BizException {
		Map<Long, BigDecimal> map = new HashMap<>();
		if (ListUtils.isEmpty(ids) || partyId == null) {
			return map;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, BigDecimal>>> responseEntityP = settlementService.getAdviserIncomeByCondition(ids, type, partyId, groupQrcodeId, bookGroupId);
			map = ResponseHandleUtil.parseMap(responseEntityP, Long.class, BigDecimal.class);
		} catch (Exception e) {
			LOGGER.error("获取收益.[getAdviserIncomeByCondition]:" + e.getMessage(), e);
		}
		return map;
	}

	@ParamLog(value = "获取日期列表", isBefore = false, isAfterReturn = false)
	public List<Date> getDateList(Integer dayNum, Date startDate, Date endDate) throws BizException {
		List<Date> dateList = new ArrayList<>();
		String startStr = null;
		String endStr = null;
		if (null != startDate) {
			startStr = DateUtils.formatDate(startDate, DateUtils.DATE_FORMAT_DATETIME);
			endStr = DateUtils.formatDate(endDate, DateUtils.DATE_FORMAT_DATETIME);
		}
		try {
			ResponseEntity<ResponseDto<List<Date>>> responseEntityP = settlementService.getDateList(dayNum, startStr, endStr);
			dateList = ResponseHandleUtil.parseList(responseEntityP, Date.class);
		} catch (Exception e) {
			LOGGER.error("获取日期列表.[getDateList]:" + e.getMessage(), e);
		}
		return dateList;
	}

	@ParamLog(value = "社群码应用下商品的收益", isBefore = false, isAfterReturn = false)
	public Map<Long,List<ResourcesStatisticVO>> getProductStaticUnderApp(ProductStaticUnderAppMapDTO productStaticUnderAppMapDTO) throws BizException {
        Map<Long,List<ResourcesStatisticVO>> resourcesStatisticVOS = new HashMap<>();
		try {
			ResponseEntity<ResponseDto<Map<Long,List<ResourcesStatisticVO>>>> responseEntityP = bookService.getProductStaticUnderAppMap(productStaticUnderAppMapDTO);
			resourcesStatisticVOS = ResponseHandleUtil.parseMapList(responseEntityP, Long.class, ResourcesStatisticVO.class);
		} catch (Exception e) {
			LOGGER.error("社群码应用下商品的收益.[getProductStaticUnderApp]:" + e.getMessage(), e);
		}
		return resourcesStatisticVOS;
	}

	@ParamLog(value = "获取书刊编辑收益和出版收益", isBefore = false, isAfterReturn = false)
	public AgentBookIncomeDTO getAgentAndAdviserIncome(AgentBookIncomeParamDTO agentBookIncomeParamDTO) throws BizException {
		AgentBookIncomeDTO agentBookIncomeDTO=new AgentBookIncomeDTO();
		if (agentBookIncomeParamDTO==null) {
			return agentBookIncomeDTO;
		}
		try {
			agentBookIncomeDTO= ResponseHandleUtil.parseResponse(settlementService.getAgentAndAdviserIncome(agentBookIncomeParamDTO), AgentBookIncomeDTO.class);
		} catch (Exception e) {
			LOGGER.error("获取书刊编辑收益和出版收益.[getAgentAndAdviserIncome]:" + e.getMessage(), e);
		}
		return agentBookIncomeDTO;
	}

	@ParamLog(value = "批量获取书刊编辑收益和出版收益", isBefore = false, isAfterReturn = false)
	public Map<String, AgentBookIncomeDTO> getAgentsIncome(AgentBookIncomeParamListDTO agentBookIncomeParamListDTO) throws BizException {
		Map<String, AgentBookIncomeDTO> result=new HashMap<>();
		if (agentBookIncomeParamListDTO==null) {
			return result;
		}
		try {
			result= ResponseHandleUtil.parseMap(settlementService.getAgentsIncome(agentBookIncomeParamListDTO), String.class,AgentBookIncomeDTO.class);
		} catch (Exception e) {
			LOGGER.error("批量获取书刊编辑收益和出版收益.[getAgentsIncome]:" + e.getMessage(), e);
		}
		return result;
	}

	@ParamLog("获取书刊收益")
	public Map<String, BigDecimal> getAllBookIncome(AllBookIncomeParamDTO paramDTO) throws BizException {
		Map<String, BigDecimal> map = new HashMap<>();
		if (paramDTO == null || ListUtils.isEmpty(paramDTO.getBookIds())
				|| ListUtils.isEmpty(paramDTO.getAdviserIds())
				|| ListUtils.isEmpty(paramDTO.getChannelIds())) {
			return map;
		}
		try {
			map = ResponseHandleUtil.parseMapResponse(settlementService.getAllBookIncome(paramDTO), String.class, BigDecimal.class);
		} catch (Exception e) {
			LOGGER.error("获取书刊收益.[getAllBookIncome]:" + e.getMessage(), e);
		}
		return map;
	}
}
