package com.pcloud.book.copyright.tools;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.copyright.biz.impl.BookAuthInfoBizImpl;
import com.pcloud.channelcenter.base.exceptions.ChannelBizException;
import com.pcloud.common.constant.OSConstant;
import com.pcloud.common.utils.FileUtils;
import com.pcloud.common.utils.UUIDUitl;
import com.pcloud.common.utils.aliyun.OssUtils;

import com.pcloud.common.utils.string.StringUtil;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 表格处理
 *
 * @author lili
 * @date 创建时间：2018年1月10日 下午2:42:39
 */
public class ExcelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelUtil.class);
    @SuppressWarnings({"resource", "deprecation"})
    public static String[][] getData(String url, int ignoreRows)
            throws IOException {
        String outDirUrl = OSConstant.USERDIR + "/download/authcode/" + UUIDUitl.taskName();
        FileUtils.isDir(outDirUrl);
        String outPutUrl = outDirUrl + "/temp.xls";
        OssUtils.downloadFile(url, outPutUrl);
        List<String[]> result = new ArrayList<String[]>();
        String[][] resultStr = null;
        int rowSize = 0;
        // 打开HSSFWorkbook
        POIFSFileSystem fs = new POIFSFileSystem(new File(outPutUrl));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        try {
            HSSFCell cell = null;
            List<Integer> temp = new ArrayList<>();
            for (int sheetIndex = 0; sheetIndex < wb.getNumberOfSheets(); sheetIndex++) {
                HSSFSheet st = wb.getSheetAt(sheetIndex);
                // 第一行为标题，不取
                for (int rowIndex = ignoreRows; rowIndex <= st.getLastRowNum(); rowIndex++) {
                    HSSFRow row = st.getRow(rowIndex);
                    if (row == null) {
                        continue;
                    }
                    int tempRowSize = row.getLastCellNum() + 1;
                    if (tempRowSize > rowSize) {
                        rowSize = tempRowSize;
                    }
                    String[] values = new String[rowSize];
                    Arrays.fill(values, "");
                    boolean hasValue = false;
                    for (short columnIndex = 0; columnIndex <= row.getLastCellNum(); columnIndex++) {
                        String value = "";
                        cell = row.getCell(columnIndex);
                        if (cell != null) {
                            // 注意：一定要设成这个，否则可能会出现乱码
                            //cell.set.setEncoding(HSSFCell.ENCODING_UTF_16);
                            switch (cell.getCellType()) {
                                case HSSFCell.CELL_TYPE_STRING:
                                    value = cell.getStringCellValue();
                                    break;
                                case HSSFCell.CELL_TYPE_NUMERIC:
                                    if (HSSFDateUtil.isCellDateFormatted(cell)) {
                                        Date date = cell.getDateCellValue();
                                        if (date != null) {
                                            value = new SimpleDateFormat("yyyy-MM-dd")
                                                    .format(date);
                                        } else {
                                            value = "";
                                        }
                                    } else {
                                        value = new DecimalFormat("0").format(cell
                                                .getNumericCellValue());
                                    }
                                    break;
                                case HSSFCell.CELL_TYPE_FORMULA:
                                    // 导入时如果为公式生成的数据则无值
                                    if (!cell.getStringCellValue().equals("")) {
                                        value = cell.getStringCellValue();
                                    } else {
                                        value = cell.getNumericCellValue() + "";
                                    }
                                    break;
                                case HSSFCell.CELL_TYPE_BLANK:
                                    break;
                                case HSSFCell.CELL_TYPE_ERROR:
                                    value = "";
                                    break;
                                case HSSFCell.CELL_TYPE_BOOLEAN:
                                    value = (cell.getBooleanCellValue() == true ? "Y"
                                            : "N");
                                    break;
                                default:
                                    value = "";
                            }
                            if (!rightTrim(value).trim().equals("")) {
                                hasValue = true;
                            }
                            values[columnIndex] = rightTrim(value);
                        } else {
                            values[columnIndex] = null;
                        }

                    }
                    if (!hasValue) {
                        temp.add(rowIndex - 1);
                    }
                    result.add(values);
                }
            }
            String[][] returnArray = new String[result.size()][rowSize + 1];
            for (int i = 0; i < returnArray.length; i++) {
                returnArray[i] = (String[]) result.get(i);
            }
            resultStr = new String[result.size() - temp.size()][rowSize + 1];
            int j = 0;
            HSSFSheet st = wb.getSheetAt(0);
            for (int i = 0; i < resultStr.length; i++) {
                if (temp.contains(i) || i >= returnArray.length) {
                    continue;
                }
                resultStr[j] = returnArray[i];
                j++;
            }
        } catch (Exception e) {
            LOGGER.error("读取表格失败" + e.getMessage(), e);
            return null;
        } finally {
            if (fs != null) {
                fs.close();
            }
            if (wb != null) {
                wb.close();
            }
            FileUtils.deleteDirectory(outDirUrl);
        }
        return resultStr;
    }

    /**
     * 去掉字符串右边的空格
     *
     * @param str 要处理的字符串
     * @return 处理后的字符串
     */
    public static String rightTrim(String str) {
        if (str == null) {
            return "";
        }
        int length = str.length();
        for (int i = length - 1; i >= 0; i--) {
            if (str.charAt(i) != 0x20) {
                break;
            }
            length--;
        }
        return str.substring(0, length);
    }

    public static String[][] getData(File file, int ignoreRows)
            throws FileNotFoundException, IOException {
        List<String[]> result = new ArrayList<String[]>();
        int rowSize = 0;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(
                file));
        // 打开HSSFWorkbook
        POIFSFileSystem fs = new POIFSFileSystem(in);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFCell cell = null;
        List<Integer> temp = new ArrayList<>();
        for (int sheetIndex = 0; sheetIndex < wb.getNumberOfSheets(); sheetIndex++) {
            HSSFSheet st = wb.getSheetAt(sheetIndex);
            // 第一行为标题，不取
            for (int rowIndex = ignoreRows; rowIndex <= st.getLastRowNum(); rowIndex++) {
                HSSFRow row = st.getRow(rowIndex);
                if (row == null) {
                    continue;
                }
                int tempRowSize = row.getLastCellNum() + 1;
                if (tempRowSize > rowSize) {
                    rowSize = tempRowSize;
                }
                String[] values = new String[rowSize];
                Arrays.fill(values, "");
                boolean hasValue = false;
                for (short columnIndex = 0; columnIndex <= row.getLastCellNum(); columnIndex++) {
                    String value = "";
                    cell = row.getCell(columnIndex);
                    if (cell != null) {
                        // 注意：一定要设成这个，否则可能会出现乱码
                        //cell.set.setEncoding(HSSFCell.ENCODING_UTF_16);
                        switch (cell.getCellType()) {
                            case HSSFCell.CELL_TYPE_STRING:
                                value = cell.getStringCellValue();
                                break;
                            case HSSFCell.CELL_TYPE_NUMERIC:
                                if (HSSFDateUtil.isCellDateFormatted(cell)) {
                                    Date date = cell.getDateCellValue();
                                    if (date != null) {
                                        value = new SimpleDateFormat("yyyy-MM-dd")
                                                .format(date);
                                    } else {
                                        value = "";
                                    }
                                } else {
                                    value = new DecimalFormat("0").format(cell
                                            .getNumericCellValue());
                                }
                                break;
                            case HSSFCell.CELL_TYPE_FORMULA:
                                // 导入时如果为公式生成的数据则无值
                                if (!cell.getStringCellValue().equals("")) {
                                    value = cell.getStringCellValue();
                                } else {
                                    value = cell.getNumericCellValue() + "";
                                }
                                break;
                            case HSSFCell.CELL_TYPE_BLANK:
                                break;
                            case HSSFCell.CELL_TYPE_ERROR:
                                value = "";
                                break;
                            case HSSFCell.CELL_TYPE_BOOLEAN:
                                value = (cell.getBooleanCellValue() == true ? "Y"
                                        : "N");
                                break;
                            default:
                                value = "";
                        }
                        if (!rightTrim(value).trim().equals("")) {
                            hasValue = true;
                        }
                        values[columnIndex] = rightTrim(value);
                    } else {
                        values[columnIndex] = null;
                    }

                }
                if (!hasValue) {
                    temp.add(rowIndex - 1);
                }
                result.add(values);
            }
        }
        in.close();
        String[][] returnArray = new String[result.size()][rowSize + 1];
        for (int i = 0; i < returnArray.length; i++) {
            returnArray[i] = (String[]) result.get(i);
        }
        String[][] resultStr = new String[result.size() - temp.size()][rowSize + 1];
        int j = 0;
        HSSFSheet st = wb.getSheetAt(0);
        for (int i = 0; i < returnArray.length; i++) {
            if (temp.contains(i)) {
                continue;
            }
            resultStr[j] = returnArray[i];
            j++;
        }

        return resultStr;
    }
}
