package com.pcloud.book.cultivate.dao.impl;

import com.pcloud.book.cultivate.dao.CultivateHoldSeatDao;
import com.pcloud.book.cultivate.entity.CultivateHoldSeat;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("cultivateHoldSeatDao")
public class CultivateHoldSeatDaoImpl extends BaseDaoImpl<CultivateHoldSeat> implements CultivateHoldSeatDao {


    @Override
    public void deleteById(Long cultivateId,Long friendCultivateId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cultivateId",cultivateId);
        map.put("friendCultivateId",friendCultivateId);
        super.getSqlSession().update(getStatement("deleteById"), map);
    }

    @Override
    public List<Long> getCultivateIdByFriendId(Long friendCultivateId) {
        Map<String,Object> map=new HashMap<>();
        map.put("friendCultivateId",friendCultivateId);
        return super.getSqlSession().selectList(getStatement("getCultivateIdByFriendId"), map);
    }

    @Override
    public Long getFriendCultivateIdById(Long cultivateId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cultivateId",cultivateId);
        return super.getSqlSession().selectOne(getStatement("getFriendCultivateIdById"), map);
    }

    @Override
    public CultivateHoldSeat getById(Long cultivateId, Long friendCultivateId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cultivateId",cultivateId);
        map.put("friendCultivateId",friendCultivateId);
        return super.getSqlSession().selectOne(getStatement("getById"), map);
    }
}
