package com.pcloud.book.es.service.impl;

import com.pcloud.book.es.biz.ESBookGroupQrcodeBiz;
import com.pcloud.book.es.dto.ESBookGroupQrcodeDTO;
import com.pcloud.book.es.repository.BookGroupQrcodeRepository;
import com.pcloud.book.es.service.ESBookGroupQrcodeService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController("esBookGroupQrcodeService")
@RequestMapping("esBookGroupQrcodeService")
public class ESBookGroupQrcodeServiceImpl implements ESBookGroupQrcodeService {

    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private BookGroupQrcodeRepository bookGroupQrcodeRepository;
    @Autowired
    private ESBookGroupQrcodeBiz esBookGroupQrcodeBiz;


    @Override
    @ApiOperation("通过微信群ID(xxx@chatroom)获取ES中的群信息")
    @RequestMapping(value = "searchByWxGroupIds", method = RequestMethod.GET)
    public List<ESBookGroupQrcodeDTO> searchByWxGroupIds(@RequestParam("wxGroupIds") List<String> wxGroupIds) {
        return esBookGroupQrcodeBiz.searchByWxGroupIds(wxGroupIds);
    }

    @Override
    @ApiOperation("更新ES中的群信息")
    @RequestMapping(value = "save", method = RequestMethod.POST)
    public void save(@RequestBody List<ESBookGroupQrcodeDTO> dtos) {
        esBookGroupQrcodeBiz.save(dtos);
    }
}
