package com.pcloud.book.giftcoupon.check;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.giftcoupon.dao.GiftCouponPackageDao;
import com.pcloud.book.giftcoupon.entity.GiftCouponPackage;
import com.pcloud.book.giftcoupon.entity.GiftReceive;
import com.pcloud.book.giftcoupon.enums.CouponTypeEnum;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

import lombok.extern.slf4j.Slf4j;

@Component("giftParamCheck")
@Slf4j
public class GiftParamCheck {

    private final Integer COUPON_MAX_TITLE_LENGTH=20;
    private final Integer COUPON_MAX_DENOMINATION=999;
    private final Integer COUPON_MAX_ADDRESS_LENGTH=800;
    private final Integer COUPON_MAX_STOCK=99999;
    private final Integer COUPON_MAX_RECEIVE=5;
    private final Integer COUPON_MIN_RECEIVE=1;

    @Autowired
    private GiftCouponPackageDao giftCouponPackageDao;

    public void checkGiftAddParam(GiftCouponPackage giftCouponPackage) {
        if (null == giftCouponPackage) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数为空");
        }
        if(null==giftCouponPackage.getCouponType()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请选择礼券类型");
        }
        if (StringUtil.isEmpty(giftCouponPackage.getTitle())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "资源简称为空");
        }
        if (giftCouponPackage.getTitle().length()>COUPON_MAX_TITLE_LENGTH) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "标题名称最多"+COUPON_MAX_TITLE_LENGTH+"个字");
        }
        if(CouponTypeEnum.BOOK_COIN_COUPON.value.equals(giftCouponPackage.getCouponType())) {
           /* if (null == giftCouponPackage.getDenomination()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "面额为空");
            }
            if (giftCouponPackage.getDenomination() > COUPON_MAX_DENOMINATION) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "面额最多"+COUPON_MAX_DENOMINATION);
            }*/
        }
        if(CouponTypeEnum.COURSE_COUPON.value.equals(giftCouponPackage.getCouponType())){
            if(null==giftCouponPackage.getUseType()){
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "使用方式为空");
            }
            if(null==giftCouponPackage.getThirdResourceId()){
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "选择外链为空");
            }
           /* if(StringUtil.isBlank(giftCouponPackage.getExchangeAddress())){
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "兑换地址为空");
            }
            if(giftCouponPackage.getExchangeAddress().length()>COUPON_MAX_ADDRESS_LENGTH){
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "兑换地址太长，最多"+COUPON_MAX_ADDRESS_LENGTH+"个字");
            }*/
        }
        if (null == giftCouponPackage.getStock()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "库存为空");
        }
        if (giftCouponPackage.getStock()>COUPON_MAX_STOCK) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "库存最多"+COUPON_MAX_STOCK);
        }
        if (null == giftCouponPackage.getReceiveLimit()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "领取上限为空");
        }
        if(CouponTypeEnum.BOOK_COIN_COUPON.value.equals(giftCouponPackage.getCouponType()) || CouponTypeEnum.COURSE_COUPON.value.equals(giftCouponPackage.getCouponType())) {
            if (giftCouponPackage.getReceiveLimit() > COUPON_MAX_RECEIVE) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "领取上限最多" + COUPON_MAX_RECEIVE + "张");
            }
            if (giftCouponPackage.getReceiveLimit() < COUPON_MIN_RECEIVE) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "领取上限最低" + COUPON_MIN_RECEIVE + "张");
            }
        }
        if(CouponTypeEnum.APP_PRODUCT.value.equals(giftCouponPackage.getCouponType())){
            if (giftCouponPackage.getReceiveLimit() > COUPON_MIN_RECEIVE) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "领取上限最多" + COUPON_MIN_RECEIVE + "张");
            }
            if(null==giftCouponPackage.getServeId()){
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请选择应用或者作品");
            }
        }
        if (StringUtil.isEmpty(giftCouponPackage.getValidDateBegin()) || StringUtil.isEmpty(giftCouponPackage.getValidDateEnd())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "有效期为空");
        }
        if (DateUtils.getDateByStr(giftCouponPackage.getValidDateBegin()).after(DateUtils.getDateByStr((giftCouponPackage.getValidDateEnd())))) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "有效期开始时间不能大于结束时间");
        }
        if (DateUtils.getDateByStr(giftCouponPackage.getValidDateEnd()).before(new Date())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "有效期结束时间不能小于当前时间");
        }
        if(StringUtil.isBlank(giftCouponPackage.getInstructions())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "使用说明不能为空");
        }
        if(null==giftCouponPackage.getRecToPage()){
            giftCouponPackage.setRecToPage(true);
        }
        if(null==giftCouponPackage.getOnShelves()){
            giftCouponPackage.setOnShelves(true);
        }
        if(StringUtil.isNotBlank(giftCouponPackage.getResourceNumber())){
           Integer i= giftCouponPackageDao.getByResourceNumber(giftCouponPackage.getResourceNumber(),giftCouponPackage.getId());
           if(i>0){
               throw new BookBizException(BookBizException.PARAM_IS_NULL, "已存在相同的资源编号");
           }
        }
    }

    public void checkGiftReceiveAddParam(GiftReceive giftReceive) {
        if (null == giftReceive) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数为空");
        }
        if (null==giftReceive.getWechatUserId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "用户为空");
        }
        if (null==giftReceive.getGiftPackageId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "奖券包id为空");
        }
        /*if (null==giftReceive.getRightsSettingId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "权益id为空");
        }*/
    }
}
