package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.BookAppletSceneDao;
import com.pcloud.book.group.dto.BookAppletSceneDTO;
import com.pcloud.book.group.entity.BookAppletScene;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 社群书小程序码
 */
@Component("bookGroupAppletDao")
public class BookAppletSceneDaoImpl extends BaseDaoImpl<BookAppletScene> implements BookAppletSceneDao {
    @Override
    public BookAppletScene getByAppletId(String appletId) {
        return getSessionTemplate().selectOne(getStatement("getByAppletId"), appletId);
    }

    @Override
    public BookAppletScene getByBookGroupId(Long bookGroupId) {
        return getSessionTemplate().selectOne(getStatement("getByBookGroupId"), bookGroupId);
    }

    @Override
    public void updateRaysClassifyIdByBookGroupId(Long raysClassifyId, Long bookGroupId) {
        Map<String,Object> map = new HashMap<>();
        map.put("raysClassifyId", raysClassifyId);
        map.put("bookGroupId", bookGroupId);
        getSessionTemplate().update(getStatement("updateRaysClassifyIdByBookGroupId"),map);
    }

    @Override
    public void deleteByBookGroupId(Long bookGroupId) {
        getSessionTemplate().update(getStatement("deleteByBookGroupId"), bookGroupId);
    }

    @Override
    public BookAppletScene getBySceneId(Long sceneId) {
        return getSessionTemplate().selectOne(getStatement("getBySceneId"), sceneId);
    }

    @Override
    public BookAppletSceneDTO getBySceneIds(List<Long> sceneIds) {
        return getSessionTemplate().selectOne(getStatement("getBySceneIds"), sceneIds);
    }

    @Override
    public BookAppletSceneDTO getBookAppletByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String,Object> map = new HashMap<>();
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("adviserId", adviserId);
        return getSessionTemplate().selectOne(getStatement("getBookAppletByBookId"), map);
    }
}
