package com.pcloud.book.group.dao.impl;

import cn.hutool.core.map.MapUtil;
import com.pcloud.book.book.vo.BookResourceNumDTO;
import com.pcloud.book.group.dao.BookGroupServeDao;
import com.pcloud.book.group.dto.BookGroupCountDTO;
import com.pcloud.book.group.dto.BookGroupServeCountDTO;
import com.pcloud.book.group.entity.BookGroupApp;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.group.vo.BookGroupServeCountVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import com.pcloud.common.utils.ListForInSQL;
import com.pcloud.common.utils.ListUtils;
import org.apache.commons.collections.ArrayStack;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/23 15:39
 **/
@Component("bookGroupServeDao")
public class BookGroupServeDaoImpl extends BaseDaoImpl<BookGroupServe> implements BookGroupServeDao {
    @Override
    public Integer batchInsert(List<BookGroupServe> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public List<BookGroupServe> getListByBookGroupId(Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        return super.getSqlSession().selectList(getStatement("getListByBookGroupId"), map);
    }

    @Override
    public void deleteByBookGroupId(Long bookGroupId) {
        super.getSqlSession().delete(getStatement("deleteByBookGroupId"), bookGroupId);
    }

    @Override
    public List<BookGroupServe> getListByServerType(String serveType) {
        return super.getSqlSession().selectList(getStatement("getListByServerType"), serveType);
    }

    @Override
    public void updateShortUrl(Long id, String shortUrl) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        map.put("shortUrl", shortUrl);
        super.getSqlSession().update(getStatement("updateShortUrl"), map);
    }

    @Override
    public List<BookGroupServe> getProductServeList() {
        return super.getSqlSession().selectList(getStatement("getProductServeList"));
    }

    @Override
    public List<BookGroupApp> getAllAppServe() {
        return super.getSqlSession().selectList(getStatement("getAllAppServe"));
    }

    @Override
    public Integer getCountByBookGroupId(Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        return super.getSqlSession().selectOne(getStatement("getCountByBookGroupId"), map);
    }

    @Override
    public List<BookGroupServe> getListByBookGroupIds(List<Long> bookGroupIds) {
        return super.getSqlSession().selectList(getStatement("getListByBookGroupIds"), bookGroupIds);
    }

    @Override
    public void deleteByBookGroupIds(List<Long> bookGroupIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupIds", bookGroupIds);
        super.getSqlSession().delete(getStatement("deleteByBookGroupIds"), map);
    }

    @Override
    public List<BookGroupCountDTO> getCountByServeIds(List<Long> serveIds, String serveType, Long adviserId) {
        Map<String, Object> map = new HashMap<>();
        map.put("serveIds", serveIds);
        map.put("serveType", serveType);
        map.put("adviserId", adviserId);
        return super.getSqlSession().selectList(getStatement("getCountByServeIds"), map);
    }

    @Override
    public List<BookGroupServe> getTypeCodeNull(String serveType) {
        return super.getSqlSession().selectList(getStatement("getTypeCodeNull"), serveType);
    }

    @Override
    public void batchUpdate(List<BookGroupServe> bookGroupServeList) {
        getSessionTemplate().update(getStatement("batchUpdate"), bookGroupServeList);
    }

    @Override
    public List<BookGroupServeCountVO> getServeList4Applet(List<Long> bookIds) {
        return ListUtils.groupList4SQL(new ListForInSQL<BookGroupServeCountVO>() {
            @Override
            public <T> List<T> processSQL(List<Long> list) {
                Map<String,Object> map = new HashMap<>();
                map.put("bookIds", list);
                return getSessionTemplate().selectList(getStatement("getServeList4Applet"), map);
            }
        }, bookIds);




    }

    @Override
    public Map<String, BookGroupServeCountDTO> mapBookGroupServeCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds) {
        Map<String,Object> map = new HashMap<>();
        map.put("adviserIds", adviserIds);
        map.put("bookIds", bookIds);
        map.put("channelIds", channelIds);
        return getSessionTemplate().selectMap(getStatement("mapBookGroupServeCount"), map, "bookChannelAdviserId");
    }

    @Override
    public Map<String, BookGroupServeCountDTO> mapBookGroupQrcodeServeCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds, Integer joinGroupType) {
        if (bookIds != null && bookIds.size() > 500) {
            Map<String, BookGroupServeCountDTO>resultMap = new HashMap<>();
            List<List<Long>> lists = ListUtils.groupList(bookIds);
            for (List<Long> list : lists) {
                Map<String, Object> map = new HashMap<>();
                map.put("adviserIds", adviserIds);
                map.put("bookIds", list);
                map.put("channelIds", channelIds);
                map.put("joinGroupType", joinGroupType);
                Map<String, BookGroupServeCountDTO> objectObjectMap = getSessionTemplate().selectMap(getStatement("mapBookGroupQrcodeServeCount"), map, "bookChannelAdviserId");
                if(objectObjectMap!=null){
                    resultMap.putAll(objectObjectMap);
                }
            }
            return resultMap;
        } else {
            Map<String, Object> map = new HashMap<>();
            map.put("adviserIds", adviserIds);
            map.put("bookIds", bookIds);
            map.put("channelIds", channelIds);
            map.put("joinGroupType", joinGroupType);
            return getSessionTemplate().selectMap(getStatement("mapBookGroupQrcodeServeCount"), map, "bookChannelAdviserId");
        }
    }

    @Override
    public List<BookGroupServe> getServeListByBook(Long bookId, Long channelId, Long adviserId) {
        Map<String,Object> map = new HashMap<>();
        map.put("adviserId", adviserId);
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        return getSessionTemplate().selectList(getStatement("getServeListByBook"), map);
    }

    @Override
    public List<BookResourceNumDTO> listResourceNum4AdviserBook(List<Long> adviserIds, List<Long> channelIds, List<Long> bookIds) {
        HashMap<String, List<Long>> param = MapUtil.of("adviserIds", adviserIds);
        param.put("channelIds", channelIds);
        param.put("bookIds", bookIds);
        return getSessionTemplate().selectList(getStatement("listResourceNum4AdviserBook"), param);
    }

    @Override
    public List<BookGroupServe> getServeListByBookAndType(Long bookId, Long channelId, Long adviserId, List<String> typeCodes) {
        Map<String,Object> map = new HashMap<>();
        map.put("adviserId", adviserId);
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("typeCodes", typeCodes);
        return getSessionTemplate().selectList(getStatement("getServeListByBookAndType"), map);
    }
}
