package com.pcloud.book.group.entity;

import com.pcloud.common.entity.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 描述  :二维码样式
 *
 * @author 作者: lili
 * @version 1.0
 * @date 创建时间：2017年6月27日 下午2:21:52
 */
@ApiModel(description = "二维码样式实体")
@Data
public class GroupQrcodeStyle extends BaseEntity {

    /**
     *
     */
    private static final long serialVersionUID = 295177552508858505L;

    /**
     * 二维码样式标识
     */
    @ApiModelProperty(value = "二维码样式标识", dataType = "Long")
    private Long qrcodeStyleId;
    /**
     * logo图
     */
    @ApiModelProperty(value = "logo图", dataType = "String")
    private String logoUrl;

    /**
     * 颜色红(原)
     */
    @ApiModelProperty(value = "颜色红(原)", dataType = "Integer")
    private Integer oldRedColor;
    /**
     * 颜色绿(原)
     */
    @ApiModelProperty(value = "颜色绿(原)", dataType = "Integer")
    private Integer oldGreenColor;
    /**
     * 颜色蓝(原)
     */
    @ApiModelProperty(value = "颜色蓝(原)", dataType = "Integer")
    private Integer oldBlueColor;
   
    /**
     * 颜色红
     */
    @ApiModelProperty(value = "颜色红", dataType = "Integer")
    private Integer newRedColor;
    /**
     * 颜色绿
     */
    @ApiModelProperty(value = "颜色绿", dataType = "Integer")
    private Integer newGreenColor;
    /**
     * 颜色蓝
     */
    @ApiModelProperty(value = "颜色蓝", dataType = "Integer")
    private Integer newBlueColor;

    /**
     * 前景色
     */
    @ApiModelProperty(value = "前景色", dataType = "String")
    private String onColor;

    /**
     * 样式类型
     */
    @ApiModelProperty(value = "样式类型", dataType = "Integer")
    private Integer styleType;

    /**
     * 社群码id
     */
    @ApiModelProperty(value = "社群码id", dataType = "Long")
    private Long bookGroupId;


}
