package com.pcloud.book.group.mapper;

import com.pcloud.book.group.entity.MpServiceMapping;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 公众号服务类型映射表(MpServiceMapping)表数据库访问层
 *
 * @author guiq
 * @since 2020-12-25 10:57:45
 */
@Mapper
@Component
public interface MpServiceMappingMapper {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    MpServiceMapping queryById(Long id);

    /**
     * 查询指定行数据
     *
     * @param offset 查询起始位置
     * @param limit  查询条数
     * @return 对象列表
     */
    List<MpServiceMapping> queryAllByLimit(@Param("offset") int offset, @Param("limit") int limit);


    /**
     * 通过实体作为筛选条件查询
     *
     * @param mpServiceMapping 实例对象
     * @return 对象列表
     */
    List<MpServiceMapping> queryAll(MpServiceMapping mpServiceMapping);

    /**
     * 新增数据
     *
     * @param mpServiceMapping 实例对象
     * @return 影响行数
     */
    int insert(MpServiceMapping mpServiceMapping);

    /**
     * 批量新增数据（MyBatis原生foreach方法）
     *
     * @param entities List<MpServiceMapping> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<MpServiceMapping> entities);

    /**
     * 批量新增或按主键更新数据（MyBatis原生foreach方法）
     *
     * @param entities List<MpServiceMapping> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<MpServiceMapping> entities);

    /**
     * 修改数据
     *
     * @param mpServiceMapping 实例对象
     * @return 影响行数
     */
    int update(MpServiceMapping mpServiceMapping);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

    List<Integer> selectMapping(@Param("app") Set<String> app, @Param("product") Set<String> product);
}