package com.pcloud.book.mq.topic;

/**
 * @author 杨涛
 * @description 绑定
 * @date 2019/8/23 18:48
 */

import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.book.weixinclock.biz.WeixinClockBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.readercenter.wechat.entity.WechatGroupUser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RabbitListener(queues = MQTopicConumer.CONSUMER_WXGROUP_USER_BIND)
public class ReaderCenterBindInfoListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(ReaderCenterBindInfoListener.class);

    @Autowired
    private WeixinClockBiz weixinClockBiz;

    @RabbitHandler
    @ParamLog("接收到微信用户绑定TOPIC")
    public void process(WechatGroupUser wechatGroupUser) {
        try {
            if (null != wechatGroupUser && null != wechatGroupUser.getWechatUserId() && !StringUtil.isEmpty(wechatGroupUser.getWxUserId())) {
                weixinClockBiz.receiveWxGroupUserBindTopic(wechatGroupUser);
            }
        } catch (Exception e) {
            LOGGER.error("接收到微信用户绑定TOPIC,JMS异常+++++" + e.getMessage(), e);
        }
    }

}
