package com.pcloud.book.pcloudkeyword.dao;

import com.pcloud.book.pcloudkeyword.entity.PcloudNotKeyword;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface PcloudNotKeywordDao extends BaseDao<PcloudNotKeyword> {

    /**
     * 根据分类id查非关键词id
     * @param keywordClassifyId
     * @return
     */
    List<Long> getIdsByClassifyId(Long keywordClassifyId);

    /**
     * 根据分类id删除
     * @param keywordClassifyId
     */
    public void deleteByClassifyId(Long keywordClassifyId);

    /**
     * 根据分类id查询
     * @param keywordClassifyId
     * @return
     */
    public List<PcloudNotKeyword> getPcloudNotKeywordList(Long keywordClassifyId);

    List<PcloudNotKeyword> getPcloudNotKeywordListByMessageType(Long keywordClassifyId,Integer userMessageType);
}
