package com.pcloud.book.personal.check;


import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.keywords.enums.ReplyTypeEnum;
import com.pcloud.book.pcloudkeyword.dao.PcloudKeywordNameDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeyword;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordName;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordReply;
import com.pcloud.book.pcloudkeyword.entity.PcloudNotKeyword;
import com.pcloud.book.personal.entity.PcloudUserLabel;
import com.pcloud.book.reading.check.ParamCheck;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ParamChecker;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Component("personalCheck")
public class PersonalCheck {

    public void checkParam4SkillList(Integer skillType, String wxUserId, Integer numPerPage, Integer currentPage) {
        if (null == skillType){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"技能为空！");
        }
        if (StringUtil.isEmpty(wxUserId)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"wxUserId为空！");
        }
        ParamChecker.checkPageParamIsAbsent(currentPage,numPerPage,"分页参数错误");
    }

    public void checkUserLabel(PcloudUserLabel pcloudUserLabel) {
        if (null == pcloudUserLabel){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"pcloudUserLabel为空！");
        }
        if (StringUtil.isEmpty(pcloudUserLabel.getWxUserId())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"wxUserId为空！");
        }
        if (null == pcloudUserLabel.getPcloudLabelId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"PcloudLabelId为空！");
        }
    }
}
