package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dao.PersonalStageJumpDao;
import com.pcloud.book.personalstage.dto.PersonalStageJumpDto;
import com.pcloud.book.personalstage.entity.PersonalStageJump;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("personalStageJump")
public class PersonalStageJumpDaoImpl extends BaseDaoImpl<PersonalStageJump> implements PersonalStageJumpDao {
    @Override
    public Integer getCountByPersonalStageId(Long personalStageId) {
        return super.getSqlSession().selectOne(getStatement("getCountByPersonalStageId"), personalStageId);
    }
    @Override
    public PersonalStageJumpDto getDtoById(Long jumpId) {
        return super.getSqlSession().selectOne(getStatement("getDtoById"), jumpId);
    }

    @Override
    public List<PersonalStageJump> getByJumpType(Long personalStageId, Integer jumpType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("personalStageId", personalStageId);
        paramMap.put("jumpType", jumpType);
        return super.getSqlSession().selectList(getStatement("getByJumpType"), paramMap);
    }
}
