package com.pcloud.book.push.dao.impl;

import com.pcloud.book.push.dao.SelfPushItemDao;
import com.pcloud.book.push.entity.SelfPushItem;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：个人号群发项
 * @作者：zhuyajie
 * @创建时间：19:00 2019/11/26
 * @版本：1.0
 */
@Component("selfPushItemDao")
public class SelfPushItemDaoImpl extends BaseDaoImpl<SelfPushItem> implements SelfPushItemDao {

    @Override
    public void updatePushStatusByPushId(Integer pushStatus, Long pushId) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushStatus", pushStatus);
        map.put("pushId", pushId);
        getSessionTemplate().update(getStatement("updatePushStatusByPushId"), map);
    }

    @Override
    public List<SelfPushItem> getByPushId(Long pushId) {
        return getSessionTemplate().selectList(getStatement("getByPushId"), pushId);
    }

    @Override
    public void deleteByPushId(Long pushId) {
        getSessionTemplate().delete(getStatement("deleteByPushId"), pushId);
    }

    @Override
    public Integer getStatusByPushId(Long pushId) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushId", pushId);
        return getSessionTemplate().selectOne(getStatement("getStatusByPushId"), map);
    }

    @Override
    public List<SelfPushItem> getByPushIds(List<Long> pushIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushIds", pushIds);
        return getSessionTemplate().selectList(getStatement("getByPushIds"), map);
    }
}
