package com.pcloud.book.push.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.push.entity.SelfPushItem;
import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @描述：个人号群发记录
 * @作者：zhuyajie
 * @创建时间：16:50 2019/11/27
 * @版本：1.0
 */
@Data
public class PersonalAppletsRecordDTO extends BaseDto{

    @ApiModelProperty("群发小号id")
    private String altId;

    @ApiModelProperty("小号名称")
    private String robotName;

    @ApiModelProperty("推送id")
    private Long pushId;

    @ApiModelProperty("推送项id")
    private Long pushItemId;

    @ApiModelProperty("推送内容项类型：1文本,2链接,3应用,4图片")
    private Integer itemType;

    @ApiModelProperty("发送状态（0发送中1发送成功2发送失败）")
    private Integer pushStatus;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("发送好友数量")
    private Integer userCount;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("发送时间")
    private Date sendTime;



    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("创建人账号")
    private String userName;

    @ApiModelProperty("计划发送时间")
    private String pushSendTime;

    @ApiModelProperty("周几")
    private String weekDays;

    @ApiModelProperty("时间推送类型")
    private Integer pushType;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("发送时间拼接")
    private String realSendTime;


    @ApiModelProperty("分类名称")
    private String classifyName;

    @ApiModelProperty("小号分类id")
    private Integer classifyId;

    @ApiModelProperty("小号编号")
    private String uniqueNumber;

    @ApiModelProperty("小程序主键id")
    private Long personalAppletsId;

    @ApiModelProperty("小程序id")
    private String appletsId;

    @ApiModelProperty("小程序访问地址")
    private String appletsUrl;

    @ApiModelProperty("小程序宣传语")
    private String slogan;

    @ApiModelProperty("小程序宣图片")
    private String sloganImgUrl;








}
