package com.pcloud.book.reading.dao;

import com.pcloud.book.reading.entity.ReadingGroupRobot;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @描述：群小号关联表
 * @作者：zhuyajie
 * @创建时间：13:42 2020/1/20
 * @版本：1.0
 */
public interface ReadingGroupRobotDao extends BaseDao<ReadingGroupRobot> {

    /**
     * 更新微信群id
     * @param wxGroupId
     * @param groupId
     */
    public void updateWxGroupByGroupId(String wxGroupId, Long groupId);

    /**
     * 设置群主
     * @param altId
     * @param groupId
     */
    public void setMaster(String altId, Long groupId);

    /**
     * 获取一个小号
     * @param wxGroupId
     * @return
     */
    String getMasterRobotByWxGroupId(String wxGroupId);

    /**
     * 根据群成员数量查符合的群
     * @param count
     * @return
     */
    List<Long> getGroupIdsByCount(Integer count);

    /**
     * 该群是否符合要求
     * @param groupId
     * @param altIds
     * @return
     */
    Boolean groupExist(Long groupId, List<String> altIds);

    /**
     * 根据活动id查询
     * @param activityId
     * @return
     */
    List<ReadingGroupRobot> getByActivityId(Long activityId);

    /**
     * groupId查询
     * @param groupId
     * @return
     */
    List<ReadingGroupRobot> getByGroupId(Long groupId);
}
