package com.pcloud.book.riddle.dto;

import com.pcloud.common.dto.BaseDto;
import com.pcloud.common.entity.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 猜谜语自定义优惠券
 */
public class RiddleCouponDTO extends BaseDto{

    /**
     * id
     */
    private Long id;
    /**
     *商品名称
     */
    private String title;
    /**
     *商品主图
     */
    private String pictUrl;
    /**
     *商品原价
     */
    private BigDecimal zkFinalPrice;
    /**
     *优惠券价格
     */
    private BigDecimal couponPrice;
    /**
     *券后价
     */
    private BigDecimal afterCouponPrice;
    /**
     *领取链接
     */
    private String couponClickUrl;
    /**
     *类型（1：淘宝2：京东3：当当）
     */
    private Integer type;

    /**
     *是否开启自定义优惠券
     */
    private Boolean status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getPictUrl() {
        return pictUrl;
    }

    public void setPictUrl(String pictUrl) {
        this.pictUrl = pictUrl == null ? null : pictUrl.trim();
    }

    public BigDecimal getZkFinalPrice() {
        return zkFinalPrice;
    }

    public void setZkFinalPrice(BigDecimal zkFinalPrice) {
        this.zkFinalPrice = zkFinalPrice;
    }

    public BigDecimal getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(BigDecimal couponPrice) {
        this.couponPrice = couponPrice;
    }

    public BigDecimal getAfterCouponPrice() {
        return afterCouponPrice;
    }

    public void setAfterCouponPrice(BigDecimal afterCouponPrice) {
        this.afterCouponPrice = afterCouponPrice;
    }

    public String getCouponClickUrl() {
        return couponClickUrl;
    }

    public void setCouponClickUrl(String couponClickUrl) {
        this.couponClickUrl = couponClickUrl == null ? null : couponClickUrl.trim();
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Boolean getStatus() {
        return status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "RiddleCouponDTO{" +
                "id=" + id +
                ", title='" + title + '\'' +
                ", pictUrl='" + pictUrl + '\'' +
                ", zkFinalPrice=" + zkFinalPrice +
                ", couponPrice=" + couponPrice +
                ", afterCouponPrice=" + afterCouponPrice +
                ", couponClickUrl='" + couponClickUrl + '\'' +
                ", type=" + type +
                ", status=" + status +
                '}';
    }
}