package com.pcloud.book.rightsSetting.constants;

import com.pcloud.book.rightsSetting.enums.RightsNowItemTypeNew;
import com.pcloud.book.rightsSetting.enums.RightsWeekTypeEnum;
import com.pcloud.common.constant.CacheConstant;
import com.pcloud.common.core.constant.ProductTypeConstant;
import com.pcloud.common.enums.AppTypeEnum;

import java.util.Arrays;
import java.util.List;

public class RightsSettingConstant {

    /**
     *小程序不支持展示的应用类型
     */
    public static final String[] APPLET_APP_NOT_SUPPORT = {
            AppTypeEnum.INTERACT.value, AppTypeEnum.MEMBER.value, AppTypeEnum.ENROLL.value};
    /**
     *小程序不支持展示的商品类型
     */
    public static final String[] APPLET_PRODUCT_NOT_SUPPORT = {ProductTypeConstant.QA,ProductTypeConstant.TOOL,
            ProductTypeConstant.TUTORIAL,ProductTypeConstant.ATTENDANCE_TASK, ProductTypeConstant.MEMBER,
            ProductTypeConstant.THIRDPARTY};

    public static final Integer MAX_ITEM_COUNT = 3;


    /**
     * 答案课程弹窗
     */
    public static final String ANSWER_POPUP = CacheConstant.BOOK +"RIGHTS_SETTING:answer_popup";

    /**
     * 品牌方课程弹窗-线上网课
     */
    public static final String COURSE_POPUP = CacheConstant.BOOK +"RIGHTS_SETTING:course_popup";
    /**
     * 答案课程中视频课直播课引流
     */
    public static final String ANSWER_COURSE = CacheConstant.BOOK +"RIGHTS_SETTING:answer_course";
    /**
     * 答案课程中专享社群引流
     */
    public static final String ANSWER_GROUP = CacheConstant.BOOK +"RIGHTS_SETTING:answer_group";

    /**
     * feat: [1003898] 小睿书扫码落地页改版
     * K12 分类
     * <p>
     * 0: {assistTempletId: 48L, typeCode: "IMPORTED_HIGER", templetName: "K12同步教材教辅",…}
     * 1: {assistTempletId: 59L, typeCode: "SPECIAL_SMALL", templetName: "K12教材教辅专项",…}
     * 2: {assistTempletId: 46L, typeCode: "VACATION", templetName: "K12假期作业",…}
     * 3: {assistTempletId: 40L, typeCode: "K12", templetName: "K12试卷",…}
     * 4: {assistTempletId: 65L, typeCode: "TEACHING_NEWSPAPER", templetName: "K12报刊",…}
     * </p>
     */
    public static final Long[] K12_TEMPLATE_IDS = {48L, 59L, 46L, 40L, 65L};

    /**
     * 教辅一级分类
     */
    public static final Long[] K12_TEMPLET_ID_NEW = {534L};

    /**
     * 权益页改版
     * 17固定模块一，18固定模块二，19固定模块三
     * 3学习工具，4抽奖，5专享礼包券，6社群服务，15老师1V1，16线上专享课
     * 7线上学习/阅读提醒，8线上读书活动，9书单推荐，10资讯推送
     * 11亲子活动设计，13线下读书活动推荐，14抢兑课程/实物礼品，2线上网课，12线上精品课
     */
    public static final Integer[] RIGHTSSETTING_TYPES_NEW ={
            RightsNowItemTypeNew.FIXED_FIRST.value, RightsNowItemTypeNew.FIXED_SECOND.value, RightsNowItemTypeNew.FIXED_THIRD.value,
            RightsNowItemTypeNew.LEARNING_TOOL.value, RightsNowItemTypeNew.DRAW.value,
            RightsNowItemTypeNew.GIFT_COUPON_PACKAGE.value, RightsNowItemTypeNew.GROUP_SERVICE.value,
            RightsNowItemTypeNew.COACH.value, RightsNowItemTypeNew.ONLINE_EXCL_COURSE.value,
            RightsWeekTypeEnum.ONLINE_REMIND.key, RightsWeekTypeEnum.ONLINE_READING_ACTIVITY.key,
            RightsWeekTypeEnum.BOOK_RECOMMEND.key, RightsWeekTypeEnum.NEWS_PUSH.key,
            RightsWeekTypeEnum.FAMILY_ACTIVITY.key, RightsWeekTypeEnum.OFFLINE_READING_ACTIVITY.key,
            RightsWeekTypeEnum.COURSE_OR_GIFT.key, RightsNowItemTypeNew.ONLINE_COURSE.value, RightsWeekTypeEnum.ONLINE_QUALITY_COURSE.key};

    /**
     *固定模块2展示的应用作品类型
     * 直播课，视频，视频课，专家咨询，名师辅导
     */
    public static final List<String> FIXED_SECOND_APPLET_APP_LIST = Arrays.asList(
            AppTypeEnum.LIVE_TIMETABLE.value, AppTypeEnum.VIDEO.value, AppTypeEnum.QA.value, AppTypeEnum.TUTOR.value
    );
    public static final List<String> FIXED_SECOND_APPLET_PRODUCT_LIST = Arrays.asList(
            ProductTypeConstant.SCHEDULE, ProductTypeConstant.VIDEO, ProductTypeConstant.VIDEO_SCHEDULE
    );
    /**
     *固定模块3展示的应用作品类型
     * 图文、课件、试卷、教辅资料包、素材包、作品集、高清大图,笔顺动图，热门电子书，在线题库
     */
    public static final List<String> FIXED_THIRD_APPLET_APP_LIST = Arrays.asList(
            AppTypeEnum.PDF.value, AppTypeEnum.COURSE_WARE.value, AppTypeEnum.TEST_PAPER.value,
            AppTypeEnum.TEACH_RESOURCE.value, AppTypeEnum.IMAGE.value, AppTypeEnum.STROKE_ORDER.value,
            AppTypeEnum.EBOOK.value, AppTypeEnum.ITEM_BANK.value, AppTypeEnum.BOOK.value
    );
    public static final List<String> FIXED_THIRD_APPLET_PRODUCT_LIST = Arrays.asList(
            ProductTypeConstant.PDF,ProductTypeConstant.FORMAT, ProductTypeConstant.EBOOK,
            ProductTypeConstant.ALBUM, ProductTypeConstant.PRETEST
    );

}
