package com.pcloud.book.rightsSetting.dao;

import com.pcloud.book.book.vo.BookResourceNumDTO;
import com.pcloud.book.group.dto.BookServeDTO;
import com.pcloud.book.rightsSetting.entity.RightsNowItem;
import com.pcloud.common.core.dao.BaseDao;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/19 17:44
 **/
public interface RightsNowItemDao extends BaseDao<RightsNowItem> {

    Integer batchInsert(List<RightsNowItem> list);

    void deleteByRightsSettingId(Long rightsSettingId);

    List<RightsNowItem> getListByRightsSettingId(Long rightsSettingId,List<Integer> types);

    List<RightsNowItem> getGiftCouponListByRightsSettingId(Long id);

    List<RightsNowItem> getListByGroupIds(List<Long> groupIds);

    List<RightsNowItem> getListByRightsSettingTitleId(Long rightsSettingTitleId, List<Integer> types);

    List<RightsNowItem> getGiftCouponListByRightsSettingTitleId(Long id);

    List<Long> getAdviserGroupIds(List<Long> ids);

    List<Long> getActivityGroupIds(List<Long> ids);

    /**
     * 删除无效（删除或者下架）的资讯
     *
     * @param newsIds
     */
    void deleteInvalidNews(List<Long> newsIds);

    /**
     * 通过资讯id查询
     *
     * @param newsIds
     * @return
     */
    List<RightsNowItem> getByNewsIds(List<Long> newsIds);

    /**
     *
     * @param newArrayList
     * @return
     */
    List<RightsNowItem> getByActivityGroupIds(List<Long> newArrayList);

    /**
     * 删除失效的模板群
     * @param activityIds
     */
    void deleteInvalidActivityGroups(List<Long> activityIds);

    /**
     * 查模块立享权益
     * @author：zhuyajie
     * @date：2020/10/9 14:35
     *  * @param null
     */
    List<RightsNowItem> getItemListByRightsSettingId(Long rightsSettingId, Integer rightsNowItemType, Integer readType, Integer openState, String serveType);

    /**
     * 删除已经下架的礼券包
     * @param packageIds
     */
    void deletePackageIds(List<Long> packageIds);

    List<BookResourceNumDTO> listResourceNum4AdviserBook(List<Long> adviserIds, List<Long> channelIds, List<Long> bookIds);

    /**
     * 根据类型查权益配置的资源
     * @author：zhuyajie
     * @date：2021/2/19 17:50
     *  * @param null
     */
    List<BookServeDTO> getServeItemsByServeTypes(Long id, List<String> serveTypes, Integer limit);
}
