package com.pcloud.book.skill.biz;

import com.pcloud.book.applet.dto.AppletGroupManageDTO;
import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import com.pcloud.book.applet.dto.GroupActivity4AppletDTO;
import com.pcloud.book.skill.dto.UpdateActivityShowStateDTO;
import com.pcloud.book.skill.facade.request.GroupActivityClassifyVO;
import com.pcloud.book.skill.facade.request.GroupActivityShowStateVO;
import com.pcloud.book.skill.entity.PcloudGroupActivity;
import com.pcloud.book.skill.facade.request.SaveGroupActivityRequestVO;
import com.pcloud.book.skill.facade.request.UpdateGroupActivityRequestVO;
import com.pcloud.book.skill.facade.response.ListGroupActivityResponseVO;
import com.pcloud.book.skill.facade.response.QueryGroupActivityResponseVO;
import com.pcloud.common.page.PageBeanNew;


import java.util.List;
import java.util.Map;

public interface PcloudGroupActivityBiz {

    /**
     * 批量分类
     * 2020/6/22
     * add by pansy
     */
    void batchUpdateClassify(GroupActivityClassifyVO groupActivityClassifyVO);

    /**
     * 批量上下架
     * 2020/6/22
     * add by pansy
     */
    void batchUpdateShowState(GroupActivityShowStateVO groupActivityShowStateVO);

    /**
     * 批量删除共读
     * 2020/6/22
     * add by pansy
     */
    void deleteByIds(List<Long> ids);

    /**
     * 保存共读活动
     */
    void saveGroupActivity(SaveGroupActivityRequestVO vo);

    /**
     * 修改共读活动
     */
    void updateGroupActivity(UpdateGroupActivityRequestVO vo);

    /**
     * 删除共读
     */
    void deleteGroupActivity(Long id, Long partyId);

    /**
     * 处理共读选取
     */
    void processGroup(String wxId, String robotWxId, Long id);

    /**
     * 获取共读活动列表（分页）
     */
    PageBeanNew<QueryGroupActivityResponseVO> queryGroupActivity(String name, Long proLabelId, Long purLabelId, Long depLabelId, Integer joinType, Long firstClassify,
                                                                 Long secondClassify, Long thirdClassify,
                                                                 Long gradeLabelId,
                                                                 Long subjectLabelId, Integer numPerPage, Integer currentPage, String cityCode, Long agentId, Integer isChoose);

    /**
     * 获取共读活动列表（弹窗）
     * @param name
     * @param joinType
     * @param numPerPage
     * @param currentPage
     * @return
     */
    PageBeanNew<ListGroupActivityResponseVO> listGroupActivity(String name, Integer joinType, Integer numPerPage, Integer currentPage, Long agentId);
    /**
     * 根据分类获取社群共读
     * @return
     */
    GroupActivity4AppletDTO getGroupActivity4Applet(Long rightSettingId, Long adviserId, Long bookId, Long channelId, Integer readType);
    /**
     * 根据id获取社群共读
     * @param ids
     * @return
     */
    Map<Long, GroupActivity4AppletDTO> getByIds(List<Long> ids);

    /**
     * 根据书刊分类查社群
     * @author：zhuyajie
     * @date：2020/6/8 10:49
     *  * @param null
     */
    PageBeanNew<AppletGroupManageDTO> getGroupListByBookTemplet(Long wechatUserId, Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Integer currentPage, Integer numPerPage, Long agentId, Long thirdClassify);

    List<GroupActivity4AppletDTO> getTishBookSchoolListWrap(BaseTempletClassify baseTempletClassify, Integer limit);

    PcloudGroupActivity getById(Long id);

    void updateActivityShowState(UpdateActivityShowStateDTO showStateDTO);

    Map<Long, GroupActivity4AppletDTO> getByIds4Now(List<Long> groupIds);

    PageBeanNew<AppletGroupManageDTO> getLocalGroup(Long wechatUserId, Integer numPerPage, Integer currentPage, Long officialAccountsId);

    void updateMediaId(PcloudGroupActivity pcloudGroupActivity);

    Map<Long, GroupActivity4AppletDTO> getByIds4NowRecord(List<Long> bookGroupClassifyIds, Integer adviserGroup);

    QueryGroupActivityResponseVO getByActivityId(Long id);

    void fillThirdGroupHeadList(AppletGroupManageDTO activity4AppletDTO);
}
