package com.pcloud.book.skill.dao.impl;

import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import com.pcloud.book.skill.dao.PcloudGroupActivityDao;
import com.pcloud.book.applet.dto.GroupActivity4AppletDTO;
import com.pcloud.book.skill.entity.PcloudGroupActivity;
import com.pcloud.book.skill.facade.request.GroupActivityClassifyVO;
import com.pcloud.book.skill.facade.request.GroupActivityShowStateVO;
import com.pcloud.book.skill.facade.response.QueryGroupActivityResponseVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class PcloudGroupActivityDaoImpl extends BaseDaoImpl<PcloudGroupActivity> implements PcloudGroupActivityDao {

    @Override
    public Integer getCountByNumber(String number, Long agentId){
        Map<String,Object> map = new HashMap<>();
        map.put("number", number);
        map.put("agentId", agentId);
        return getSessionTemplate().selectOne(getStatement("getCountByNumber"), map);
    }

    @Override
    public void batchUpdateShowState(GroupActivityClassifyVO groupActivityClassifyVO) {
        Map<String,Object> map = new HashMap<>();
        map.put("ids", groupActivityClassifyVO.getIds());
        map.put("firstClassify", groupActivityClassifyVO.getFirstClassify());
        map.put("secondClassify", groupActivityClassifyVO.getSecondClassify());
        map.put("thirdClassify", groupActivityClassifyVO.getThirdClassify());
        map.put("gradeLabelId", groupActivityClassifyVO.getGradeLabelId());
        map.put("subjectLabelId", groupActivityClassifyVO.getSubjectLabelId());
        getSessionTemplate().update(getStatement("batchUpdateClassify"), map);
    }

    @Override
    public void batchUpdateShowState(GroupActivityShowStateVO groupActivityShowStateVO){
        Map<String,Object> map = new HashMap<>();
        map.put("ids", groupActivityShowStateVO.getIds());
        map.put("showState", groupActivityShowStateVO.getShowState());
        getSessionTemplate().update(getStatement("batchUpdateShowState"), map);
    }

    @Override
    public  void deleteByIds(List<Long> ids){
        getSessionTemplate().update(getStatement("deleteByIds"), ids);
    }

    @Override
    public Map<Long, PcloudGroupActivity> mayByIds(List<Long> ids) {
        return super.getSqlSession().selectMap(getStatement("mayByIds"), ids,"id");
    }

    @Override
    public void updateByPrimaryKeySelective(PcloudGroupActivity entity) {
        this.getSqlSession().update("com.pcloud.book.skill.dao.impl.PcloudGroupActivityDaoImpl.updateByPrimaryKeySelective", entity);
    }

    @Override
    public GroupActivity4AppletDTO getGroupActivity4Applet(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long thirdClassify) {
        Map<String, Object> map = new HashMap<>();
        map.put("firstClassify", firstClassify);
        map.put("secondClassify", secondClassify);
        map.put("thirdClassify", thirdClassify);
        map.put("gradeLabelId", gradeLabelId);
        map.put("subjectLabelId", subjectLabelId);
        return super.getSqlSession().selectOne(getStatement("getGroupActivity4Applet"), map);
    }

    @Override
    public List<GroupActivity4AppletDTO> getTishBookSchoolList(BaseTempletClassify baseTempletClassify, Integer limit) {
        Map<String, Object> map = new HashMap<>();
        map.put("firstClassify", baseTempletClassify.getFirstClassify());
        map.put("secondClassify", baseTempletClassify.getSecondClassify());
        map.put("thirdClassify", baseTempletClassify.getThirdClassify());
        map.put("gradeLabelId", baseTempletClassify.getGradeLabelId());
        map.put("subjectLabelId", baseTempletClassify.getSubjectLabelId());
        map.put("limit", (limit != null ? limit :10));
        map.put("agentId",baseTempletClassify.getAgentId()==null?0L:baseTempletClassify.getAgentId());
        return super.getSqlSession().selectList(getStatement("getTishBookSchoolList"), map);
    }

    @Override
    public Map<Long, GroupActivity4AppletDTO> getByIds(List<Long> list, Integer isShow) {
        Map<String, Object> map = new HashMap<>();
        map.put("list", list);
        map.put("isShow", isShow);
        return super.getSqlSession().selectMap(getStatement("getByIds"), map,"id");
    }

    @Override
    public Map<Long, GroupActivity4AppletDTO> getGroupClassifyByIds(List<Long> list){
        return super.getSqlSession().selectMap(getStatement("getGroupClassifyByIds"), list,"id");
    }

    @Override
    public List<Long> getGroupClassifyIds(Map<String, Object> paraMap) {
        return super.getSqlSession().selectList("getGroupClassifyIds",paraMap);
    }

    @Override
    public Map<Long, GroupActivity4AppletDTO> getThirdPartByIds(List<Long> list) {
        return super.getSqlSession().selectMap(getStatement("getThirdPartByIds"), list,"id");
    }

    @Override
    public PcloudGroupActivity getById(Long id){
        return super.getSqlSession().selectOne(getStatement("getById"),id);
    }

    @Override
    public QueryGroupActivityResponseVO getByActivityId(Long id) {
        return getSessionTemplate().selectOne(getStatement("getByActivityId"), id);
    }

    @Override
    public Map<Long, GroupActivity4AppletDTO> getGroupClassifyByIds4Record(List<Long> bookGroupIds) {
        return super.getSqlSession().selectMap(getStatement("getGroupClassifyByIds4Record"), bookGroupIds,"id");
    }


}
