package com.pcloud.book.skill.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel("平台端技能")
@Data
public class PcloudSkill extends BaseEntity {

    @ApiModelProperty("技能类型：1时间管理，2共读活动，3配套资料，4教辅书单，5配套老师，6音乐")
    private Integer skillType;

    @ApiModelProperty("具体关联技能id")
    private Long relSkillId;

    @ApiModelProperty("成功订阅回复集合")
    private List<PcloudSubReply> successSubReplies;

    @ApiModelProperty("取消订阅回复集合")
    private List<PcloudSubReply> cancelSubReplies;

    @ApiModelProperty("技能融合页回复")
    private String skillFuseReply;

    @ApiModelProperty("排序值")
    private Integer seqNum;

    @ApiModelProperty("技能标题")
    private String title;

    @ApiModelProperty("技能简介")
    private String detail;

    @ApiModelProperty("点击未订阅回复集合")
    private List<PcloudSubReply> noSubReplies;

    @ApiModelProperty("技能简介文字")
    private String detailString;

    @ApiModelProperty("出版社id")
    private Long agentId;
}
