package com.pcloud.book.timecontrol.mapper;

import com.pcloud.book.timecontrol.dto.SubscribeTaskUserDTO;
import com.pcloud.book.timecontrol.dto.TaskItemSendDto;
import com.pcloud.book.timecontrol.dto.TaskProgressItemDTO;
import com.pcloud.book.timecontrol.dto.TaskSendDto;
import com.pcloud.book.timecontrol.dto.TaskSendUserDto;
import com.pcloud.book.timecontrol.entity.TimeControlTaskSend;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

/**
 * @date: 2020年01月31日 20:05
 * @Author: Zcy
 * @Descprition
 */
@Component
public interface TimeControlTaskSendDetailMapper {

    void batchInsert(List<TimeControlTaskSend> taskSendList);

    Integer getTaskItemSendCount(@Param("startTime") String startTime, @Param("endTime") String endTime,
        @Param("robotWxId") String robotWxId, @Param("taskName") String taskName, @Param("sendContent") String sendContent,
                                 @Param("agentId") Long agentId);

    List<TaskItemSendDto> listTaskItemSendRecord4Pcloud(@Param("pageNum") Integer pageNum, @Param("numPerPage") Integer numPerPage,
        @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("robotWxId") String robotWxId,
        @Param("taskName") String taskName, @Param("sendContent") String sendContent, @Param("agentId") Long agentId);

    Integer getTaskItemSendUserCount(@Param("wxIds") List<String> wxIds, @Param("taskItemId") Integer taskItemId,
        @Param("robotWxId") String robotWxId,
        @Param("startTime") String startTime, @Param("endTime") String endTime);

    List<TaskSendUserDto> listTaskItemSendUser4Pcloud(@Param("pageNum") Integer pageNum, @Param("numPerPage") Integer numPerPage,
        @Param("wxIds") List<String> wxIds, @Param("taskItemId") Integer taskItemId, @Param("robotWxId") String robotWxId,
        @Param("startTime") String startTime, @Param("endTime") String endTime);

    List<SubscribeTaskUserDTO> getTaskNoCompletedCount(@Param("wxIds") List<String> wxIds, @Param("taskId") Integer taskId);

    Integer getNoCompletedCount(@Param("subscribeId") Integer subscribeId);

    Integer getCompletedCount(Integer subscribeId);

    List<TaskProgressItemDTO> getUserTaskItemProgress(@Param("taskId") Integer taskId, @Param("wxUserId") String wxUserId);

    void updateSendState4Week();

    List<TaskSendDto> listTodayTask4Week(@Param("taskItemId") Integer taskItemId, @Param("weekDay") Integer weekDay);

    void addSendCount(Integer id);

    Integer todayTaskSendCount(@Param("agentId") Long agentId);

    List<String> getTaskSendDateList(@Param("date") String date,@Param("agentId") Long agentId);
}
