package com.pcloud.book.weixinclock.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.consumer.channel.QrcodeSceneConsr;
import com.pcloud.book.consumer.user.AdviserConsr;
import com.pcloud.book.group.dao.BookGroupClassifyDao;
import com.pcloud.book.group.dao.BookGroupDao;
import com.pcloud.book.group.dao.GroupQrcodeDao;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.ClassifyDTO;
import com.pcloud.book.group.entity.GroupQrcode;
import com.pcloud.book.group.vo.ClassifyVO;
import com.pcloud.book.util.common.LunarCalendarUtils;
import com.pcloud.book.weixinclock.biz.WeixinClockShareBiz;
import com.pcloud.book.weixinclock.dao.WeixinClockMemberDao;
import com.pcloud.book.weixinclock.dao.WeixinClockPraiseDao;
import com.pcloud.book.weixinclock.dao.WeixinClockShareDao;
import com.pcloud.book.weixinclock.dao.WeixinClockShareWordDao;
import com.pcloud.book.weixinclock.dao.WeixinClockTopicDao;
import com.pcloud.book.weixinclock.dto.RankDto;
import com.pcloud.book.weixinclock.entity.WeixinClockMember;
import com.pcloud.book.weixinclock.entity.WeixinClockShare;
import com.pcloud.book.weixinclock.vo.response.DoShareResponseVO;
import com.pcloud.channelcenter.base.constants.ChannelConstants;
import com.pcloud.channelcenter.wechat.dto.AccountSettingDto;
import com.pcloud.common.utils.QrcodeUtils;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import com.pcloud.common.utils.httpclient.UrlUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.Map;

/**
 * @Describe: 微信群打卡分享逻辑层实现
 * @Author: zhangdongwei
 * @Date: Create on 10:24 2019/10/29 0029
 */
@Service("weixinClockShareBiz")
public class WeixinClockShareBizImpl implements WeixinClockShareBiz {
    @Autowired
    private WeixinClockShareWordDao weixinClockShareWordDao;
    @Autowired
    private WeixinClockMemberDao weixinClockMemberDao;
    @Autowired
    private WeixinClockTopicDao weixinClockTopicDao;
    @Autowired
    private GroupQrcodeDao groupQrcodeDao;
    @Autowired
    private WeixinClockShareDao weixinClockShareDao;
    @Autowired
    private BookGroupDao bookGroupDao;
    @Autowired
    private BookGroupClassifyDao bookGroupClassifyDao;
    @Autowired
    private AdviserConsr adviserConsr;
    @Autowired
    private QrcodeSceneConsr qrcodeSceneConsr;
    @Autowired
    private WeixinClockPraiseDao weixinClockPraiseDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public DoShareResponseVO doShare(Long wechatUserId, String wxGroupId, String wxUserId) {

        if (null == wxGroupId || null == wxUserId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "分享失败，参数为空");
        }
        RankDto rankDto = weixinClockMemberDao.getClockWechatUserRank(wechatUserId, wxGroupId);
        if (null == rankDto || null == rankDto.getWxUserId()){
            rankDto = weixinClockMemberDao.getClockWechatUserRankByWxUserId(wxUserId, wxGroupId);
        }
        if (null == rankDto){
            return new DoShareResponseVO();
        }
        wxUserId = null != rankDto.getWxUserId() ? rankDto.getWxUserId() : wxUserId;
        DoShareResponseVO doShareResponseVO = DoShareResponseVO.valueFromRankDto(rankDto);
        //获得的点赞数
        Integer pariseNum = weixinClockPraiseDao.getPraiseNum(wxGroupId, wxUserId);
        doShareResponseVO.setPraiseNum(pariseNum);
        Date today = new Date();
        Map<String, String> strMap = LunarCalendarUtils.dataToLunar(today);
        doShareResponseVO.setLunar(strMap.get("lunar"));
        doShareResponseVO.setToday(today);
        doShareResponseVO.setGanZhi(strMap.get("ganZhi"));
        String shareWord = weixinClockShareWordDao.getRoundWord();
        doShareResponseVO.setShareWord(shareWord);
        Date date = weixinClockTopicDao.getFirstClockDay(wxUserId, wxGroupId);
        doShareResponseVO.setStartClockDate(date);
        GroupQrcode groupQrcode = groupQrcodeDao.getByWxGroupId(wxGroupId);
        if (null != groupQrcode){
            ClassifyDTO dto = bookGroupClassifyDao.getById(groupQrcode.getClassifyId());
            if(null != dto){
                BookGroupDTO bookGroupDTO = bookGroupDao.getDTOById(dto.getBookGroupId());
                if (null != bookGroupDTO){
                    doShareResponseVO.setTitle(bookGroupDTO.getGroupQrcodeName());
                    doShareResponseVO.setQrcodeUrl(bookGroupDTO.getGroupQrcodeUrl());
                }
            }
        }
        //埋点，用户分享记录
        WeixinClockShare weixinClockShare = new WeixinClockShare();
        weixinClockShare.setShareTime(new Date());
        weixinClockShare.setShareUserId(wechatUserId);
        weixinClockShare.setWxGroupId(wxGroupId);
        weixinClockShareDao.insert(weixinClockShare);
        //将分享页面的二维码换成打卡排行榜的二维码
        String qrcodeUrl = JedisClusterUtils.get(wxGroupId+wxUserId);
        if (!StringUtil.isEmpty(qrcodeUrl)){
            doShareResponseVO.setQrcodeUrl(qrcodeUrl);
            return doShareResponseVO;
        }
        StringBuilder linkUrl = new StringBuilder();
        if (null == groupQrcode){
            return doShareResponseVO;
        }
        Long channelId = adviserConsr.getDefaultChannel(groupQrcode.getCreateUser());
        AccountSettingDto accountSettingDto = qrcodeSceneConsr.getWechatInfo(channelId);
        if (null == accountSettingDto) {
            return doShareResponseVO;
        }
        String protocol = accountSettingDto.getProtocol();
        if (StringUtils.isEmpty(protocol)) {
            protocol = ChannelConstants.HTTP;
        }
        linkUrl.append(protocol).append(accountSettingDto.getDomain()).append("/W")
                .append(accountSettingDto.getAccountSettingId()).append("/clock").append("?wxGroupId=")
                .append(wxGroupId).append("&wxUserId=").append(wxUserId).append("&isShare=1");
        String shortUrl4Own = UrlUtils.getShortUrl4Own(linkUrl.toString());
        qrcodeUrl = QrcodeUtils.create(shortUrl4Own);
        doShareResponseVO.setQrcodeUrl(qrcodeUrl);
        JedisClusterUtils.set(wxGroupId+wxUserId, qrcodeUrl);
        return doShareResponseVO;
    }
}
