package com.pcloud.book.weixinclock.dao;

import com.pcloud.book.weixinclock.entity.WeixinClockUserCoupon;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @Describe: 微信群打卡用户优惠dao
 * @Author: zhangdongwei
 * @Date: Create on 9:24 2019/11/19 0019
 */
public interface WeixinClockUserCouponDao extends BaseDao<WeixinClockUserCoupon> {
    /**
     * 获取我的优惠券
     * @param wxGroupId
     * @param wechatUserId
     * @return
     */
    WeixinClockUserCoupon getByGroupAndUser(String wxGroupId, Long wechatUserId);

    /**
     * 修改微信用户id
     * @param wxUserId
     * @param wechatUserId
     */
    void updateWechatUserId(String wxUserId, Long wechatUserId);

    /**
     * 获取没有wechatUserId的用户优惠券
     * @return
     */
    List<WeixinClockUserCoupon> getNoWechatUserId();
}
