package com.pcloud.book.weixinclock.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author 杨涛
 * @description 打卡记录
 * @date 2019/8/16 10:42
 */
public class WeixinClockTopic extends BaseEntity {

    private static final long serialVersionUID = -2573601301200332849L;

    @ApiModelProperty("打卡记录标识")
    private Long weixinClockTopicId;

    @ApiModelProperty("微信群签到打卡标识")
    private Long weixinClockId;

    @ApiModelProperty("打卡成员标识")
    private Long weixinClockMemberId;

    @ApiModelProperty("微信用户标识")
    private String wxUserId;

    @ApiModelProperty("群分类标识")
    private Long bookGroupClassifyId;

    @ApiModelProperty("微信群标识")
    private String wxGroupId;

    @ApiModelProperty("打卡日期")
    private Date createdDay;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    public Long getWeixinClockTopicId() {
        return weixinClockTopicId;
    }

    public void setWeixinClockTopicId(Long weixinClockTopicId) {
        this.weixinClockTopicId = weixinClockTopicId;
    }

    public Long getWeixinClockId() {
        return weixinClockId;
    }

    public void setWeixinClockId(Long weixinClockId) {
        this.weixinClockId = weixinClockId;
    }

    public Long getWeixinClockMemberId() {
        return weixinClockMemberId;
    }

    public void setWeixinClockMemberId(Long weixinClockMemberId) {
        this.weixinClockMemberId = weixinClockMemberId;
    }

    public String getWxUserId() {
        return wxUserId;
    }

    public void setWxUserId(String wxUserId) {
        this.wxUserId = wxUserId;
    }

    public Long getBookGroupClassifyId() {
        return bookGroupClassifyId;
    }

    public void setBookGroupClassifyId(Long bookGroupClassifyId) {
        this.bookGroupClassifyId = bookGroupClassifyId;
    }

    public String getWxGroupId() {
        return wxGroupId;
    }

    public void setWxGroupId(String wxGroupId) {
        this.wxGroupId = wxGroupId;
    }

    public Date getCreatedDay() {
        return createdDay;
    }

    public void setCreatedDay(Date createdDay) {
        this.createdDay = createdDay;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "WeixinClockTopicDao{" +
                "weixinClockTopicId=" + weixinClockTopicId +
                ", weixinClockId=" + weixinClockId +
                ", weixinClockMemberId=" + weixinClockMemberId +
                ", wxUserId='" + wxUserId + '\'' +
                ", bookGroupClassifyId=" + bookGroupClassifyId +
                ", wxGroupId='" + wxGroupId + '\'' +
                ", createdDay=" + createdDay +
                ", createTime=" + createTime +
                '}';
    }
}
