package test;

import com.pcloud.book.BookApplication;
import com.pcloud.book.book.biz.BookKeywordWarehouseBiz;
import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.book.vo.BookKeywordDetailVO;
import com.pcloud.book.book.vo.BookKeywordProductVO;
import com.pcloud.book.book.vo.KeywordWearhouseLabelVO;
import com.pcloud.book.book.vo.request.AddBookKeywordRequestVO;
import com.pcloud.book.book.vo.request.CheckKeywordRequestVO;
import com.pcloud.book.book.vo.request.EditBookKeywordRequestVO;
import com.pcloud.book.book.vo.request.QueryBookKeywordWarehouseRequestVO;
import com.pcloud.book.book.vo.response.BookKeywordResponseVO;
import com.pcloud.common.page.PageBeanNew;

import org.assertj.core.util.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes = {BookApplication.class, BookKeywordWarehouseBizTest.class})
public class BookKeywordWarehouseBizTest {

    @Resource
    private BookKeywordWarehouseBiz bookKeywordWarehouseBiz;

    @Resource
    private AdNewsBiz adNewsBiz;

    @Resource
    private BookGroupServeDao bookGroupServeDao;

    @Test
    public void testQuartzAdNewsBiz(){
        adNewsBiz.sendAdNews((2L));
    }

    @Test
    public void testBookGroupServeDao(){
        bookGroupServeDao.
    }

    @Test
    public void addBookKeyword() {
        AddBookKeywordRequestVO vo = new AddBookKeywordRequestVO();
        vo.setUserId(1L);
        vo.setKeyword("语文1");
        vo.setGuide("12341234");
        vo.setMatchingRule(0);
        vo.setScope(0);
        vo.setAuditStatus(1);
        List<BookKeywordDetailVO> details = Lists.newArrayList();
        for (Integer i = 1; i < 3; i++) {
            BookKeywordDetailVO v = new BookKeywordDetailVO();
            final List<KeywordWearhouseLabelVO> objects = Lists.newArrayList();
            for (Integer j = 3; j < 6; j++) {
                KeywordWearhouseLabelVO v1 = new KeywordWearhouseLabelVO();
                v1.setProfessionalLabelId(6L);
                v1.setDepthLabelId(j.longValue());
                v1.setPurposeLabelId(j.longValue());
                objects.add(v1);
            }
            v.setGroupId(1);
            v.setProductId(1L);
            v.setProductType("APP");
            v.setDescription("111");
            v.setLinkUrl("www.baidu.com");
            v.setPicUrl("www.baidu.com");
            details.add(v);
        }
        BookKeywordDetailVO v = new BookKeywordDetailVO();
        final List<KeywordWearhouseLabelVO> objects = Lists.newArrayList();
        KeywordWearhouseLabelVO v1 = new KeywordWearhouseLabelVO();
        v1.setProfessionalLabelId(6L);
        v1.setDepthLabelId(8L);
        v1.setPurposeLabelId(9L);
        objects.add(v1);
        v.setLabels(Collections.singletonList(v1));
        v.setGroupId(2);
        v.setProductId(1L);
        v.setProductType("APP");
        v.setDescription("111");
        v.setLinkUrl("www.baidu.com");
        v.setPicUrl("www.baidu.com");
        details.add(v);
        vo.setDetails(details);
        this.bookKeywordWarehouseBiz.addBookKeyword(vo, null);
    }

    @Test
    public void editBookKeyword() {
        EditBookKeywordRequestVO vo = new EditBookKeywordRequestVO();
        vo.setUserId(3L);
        vo.setKeywordId(1L);
        vo.setKeyword("数学");
        vo.setGuide("数学之美");
        vo.setMatchingRule(0);
        vo.setScope(0);
        vo.setEditorId(1L);
        List<BookKeywordDetailVO> details = Lists.newArrayList();
        for (Integer i = 0; i < 3; i++) {
            BookKeywordDetailVO v = new BookKeywordDetailVO();
            final List<KeywordWearhouseLabelVO> objects = Lists.newArrayList();
            for (Integer j = 3; j < 6; j++) {
                KeywordWearhouseLabelVO v1 = new KeywordWearhouseLabelVO();
                v1.setProfessionalLabelId(6L);
                v1.setDepthLabelId(j.longValue());
                v1.setPurposeLabelId(j.longValue());
                objects.add(v1);
            }
            v.setGroupId(1);
            v.setProductId(3L);
            v.setProductType("APP");
            v.setDescription("333");
            v.setLinkUrl("www.baidu3.com");
            v.setPicUrl("www.baidu3.com");
            details.add(v);
        }
        BookKeywordDetailVO v = new BookKeywordDetailVO();
        KeywordWearhouseLabelVO v1 = new KeywordWearhouseLabelVO();
        v1.setProfessionalLabelId(6L);
        v1.setDepthLabelId(8L);
        v1.setPurposeLabelId(9L);
        v.setLabels(Collections.singletonList(v1));
        v.setGroupId(2);
        v.setProductId(4L);
        v.setProductType("APP");
        v.setDescription("444");
        v.setLinkUrl("www.baidu4.com");
        v.setPicUrl("www.baidu4.com");
        details.add(v);
        vo.setDetails(details);
        this.bookKeywordWarehouseBiz.editBookKeyword(vo);
    }

    @Test
    public void deleteBookKeyword() {
        this.bookKeywordWarehouseBiz.deleteBookKeyword(1L, 1L);
    }

    @Test
    public void listBookKeywordWarehouse() {
        QueryBookKeywordWarehouseRequestVO vo = new QueryBookKeywordWarehouseRequestVO();
        vo.setCurrentPage(0);
        vo.setNumPerPage(10);
        vo.setKeyword("1234123414");
        final PageBeanNew<BookKeywordResponseVO> warehouse = this.bookKeywordWarehouseBiz.listBookKeywordWarehouse(vo);
        for (BookKeywordResponseVO responseVO : warehouse.getRecordList()) {
            System.out.println(responseVO);
        }
    }

    @Test
    public void useKeyword() {
        this.bookKeywordWarehouseBiz.useKeyword(1L, 1L);
    }


    @Test
    public void oftenKeyword() {
        final PageBeanNew<BookKeywordProductVO> oftenKeyword = this.bookKeywordWarehouseBiz.oftenKeyword(0, 10, 0L, 1L, 1L, 0L);
        for (BookKeywordProductVO responseVO : oftenKeyword.getRecordList()) {
            System.out.println(responseVO);
        }
    }

    @Test
    public void hotKeyword() {
        final PageBeanNew<BookKeywordProductVO> oftenKeyword = this.bookKeywordWarehouseBiz.hotKeyword(0, 10, 47L, 50L,"", 1L, 0L);
        for (BookKeywordProductVO responseVO : oftenKeyword.getRecordList()) {
            System.out.println(responseVO);
        }
    }

    @Test
    public void auditKeyword() {
        this.bookKeywordWarehouseBiz.auditKeyword(1L, 3L, BookConstant.BookKeywordAuditEnum.PASS_THE_AUDIT);
    }

    @Test
    public void checkKeyword() {
        CheckKeywordRequestVO vo = new CheckKeywordRequestVO();
        final List<Long> longs = this.bookKeywordWarehouseBiz.checkKeyword(vo);
        System.out.println(longs);
    }
}
