import json

from selenium.webdriver.support.wait import WebDriverWait

from common.untils import DriverTools
from config import file_path


def get_text(loc, time=10, fre=1):
    ele = WebDriverWait(DriverTools.get_driver(), time, fre).until(lambda x: x.find_element(*loc))
    return ele.text


def get_app_text(loc, time=10, fre=1):
    ele = WebDriverWait(DriverTools.get_app_driver(), time, fre).until(lambda x: x.find_element(*loc))
    return ele.text


def get_texts(loc, time=10, fre=1):
    eles = WebDriverWait(DriverTools.get_driver(), time, fre).until(lambda x: x.find_elements(*loc))
    ele_list = []
    for ele in eles:
        ele_list.append(ele.text)
    return ele_list


def get_app_texts(loc, time=10, fre=1):
    eles = WebDriverWait(DriverTools.get_app_driver(), time, fre).until(lambda x: x.find_elements(*loc))
    ele_list = []
    for ele in eles:
        ele_list.append(ele.text)
    return ele_list


def read_json(file_name):
    path = file_path + "/data/" + file_name
    with open(path, "r", encoding="utf-8") as f:
        data = json.load(f)
    list1 = []
    for i in data:
        temp = tuple(i.values())
        list1.append(temp)

    return list1
