import time

from selenium import webdriver
from appium import webdriver as appwebdriver

from config import appium_server_url, caps


class DriverTools:
    __driver = None
    __app_driver = None

    # 初始化web驱动
    @classmethod
    def get_driver(cls):
        if cls.__driver is None:
            cls.__driver = webdriver.Chrome()
            cls.__driver.maximize_window()
            cls.__driver.implicitly_wait(10)
        return cls.__driver

    # 关闭web驱动
    @classmethod
    def quit_driver(cls):
        if cls.__driver:
            cls.__driver.quit()
            cls.__driver = None

    # 打开app驱动
    @classmethod
    def get_app_driver(cls):
        if cls.__app_driver is None:
            cls.__app_driver = appwebdriver.Remote(appium_server_url, caps)
            cls.__app_driver.implicitly_wait(10)
        return cls.__app_driver

    # 关闭app驱动
    @classmethod
    def quit_app_driver(cls):
        if cls.__app_driver:
            cls.__app_driver.quit()
            cls.__app_driver = None


if __name__ == '__main__':
    # 测试web驱动
    DriverTools.get_driver().get('https://rays7.5rs.me/login')
    time.sleep(2)

    # # 测试app驱动
    # DriverTools.get_app_driver()
    # time.sleep(2)
    # DriverTools.quit_app_driver()
