import time
from urllib.parse import urlparse, parse_qs

from selenium.webdriver.common.by import By
from Base.BasePage import BasePage
from config import example_knowlage_file_name, example_Content_risk_file_name


# Ai审校编辑页面
class Aireview(BasePage):
    def __init__(self):
        super().__init__('web')
        # 图书审校按钮
        self.book_review_btn = (By.XPATH, "//label[@class='ant-radio-button-wrapper ant-radio-button-wrapper-checked "
                                          "proofreading-type-box']")
        # 文本审校按钮
        self.text_revierw_btn = (By.XPATH, "//div[@class='proofreading-type-checkbox']//div[2]//label[1]")

        # 繁体字审校按钮
        self.traditional_review_btn = (
            By.XPATH, "(//label[@class='ant-radio-button-wrapper proofreading-type-box'])[2]")

        # 多媒体审校按钮
        self.media_review_btn = (By.XPATH, "(//label[@class='ant-radio-button-wrapper proofreading-type-box'])[3]")

        # 查词查术语
        self.find_word_btn = (By.XPATH, "(//label[@class='ant-radio-button-wrapper proofreading-type-box'])[4]")

        # 知识查证按钮
        self.find_knowledge_btn = (By.XPATH, "(//label[@class='ant-radio-button-wrapper proofreading-type-box'])[5]")

        # 更多按钮
        self.more_btn = (By.XPATH, "//div[@class='more-btn']")

        # 发送按钮
        self.send_btn = (By.XPATH, "//button[contains(text(),'发送')]")

        # 输入框
        self.input_box = (By.XPATH, "//div[@role='textbox']")

        # 上传按钮
        self.update_key = (By.XPATH, "//div[@class='proofred_UploadBtn']//span[1]")

        # 上传文件
        self.update_file = (By.XPATH, "(//input[@id='file'])[2]")

        # 优先多检出
        self.more_find = (By.XPATH, "(//div[@class='btn-item'])[2]")

        # 优先少误报
        self.few_dind = (By.XPATH, "(//div[@class='btn-item'])[1]")

        # 开始审校按钮
        self.start_review_btn = (By.XPATH, "//button[@type='button']")

        # 示例
        self.example_btn = (By.XPATH, "//div[@class='proofred_UploadBtn-examplate-btn']//span//span[contains(text(),'示例')]")

        # 示例知识性差错文件
        self.example_knowlage_file = (By.XPATH,f"//div[@class='example-box']//span[contains(text(),'{example_knowlage_file_name}')]")

        # 示例内容风险文件
        self.example_Content_risk_file = (By.XPATH, f"//div[@class='example-box']//span[contains(text(),'{example_Content_risk_file_name}')]")

        # 审校记录
        self.review_record = (By.XPATH, "//span[contains(text(),'审校记录')]")

    # 图书审校
    def book_review(self, updata_path):
        self.find_ele(self.book_review_btn).click()
        time.sleep(10)
        self.find_ele(self.update_key).click()
        time.sleep(10)
        self.find_ele(self.update_file).send_keys(updata_path)
        time.sleep(10)
        self.find_ele(self.send_btn).click()
        time.sleep(10)
        self.find_ele(self.more_find).click()
        time.sleep(10)
        self.find_ele(self.start_review_btn).click()

    # 文本审校
    def text_revierw(self, text):
        self.find_ele(self.text_revierw_btn).click()
        time.sleep(3)
        self.find_ele(self.input_box).send_keys(text)
        time.sleep(3)
        self.find_ele(self.send_btn).click()

    # 繁体字文档审校
    def traditional_review(self, updata_path):
        self.find_ele(self.traditional_review_btn).click()
        self.find_ele(self.update_key).click()
        time.sleep(2)
        self.find_ele(self.update_file).send_keys(updata_path)
        time.sleep(5)
        self.find_ele(self.send_btn).click()

    # 多媒体审校
    def media_review(self, media_list):
        self.find_ele(self.media_review_btn).click()
        for i in media_list:
            self.find_ele(self.update_key).click()
            time.sleep(2)
            self.find_ele(self.update_file).send_keys(i)
            time.sleep(1)
        time.sleep(5)
        self.find_ele(self.send_btn).click()

    # 查词查术语
    def find_word(self, text):
        self.find_ele(self.more_btn).click()
        time.sleep(3)
        self.find_ele(self.find_word_btn).click()
        time.sleep(3)
        self.find_ele(self.input_box).send_keys(text)
        time.sleep(3)
        self.find_ele(self.send_btn).click()

    # 知识查找
    def find_knowledge(self, text):
        self.find_ele(self.more_btn).click()
        time.sleep(1)
        self.find_ele(self.find_knowledge_btn).click()
        time.sleep(1)
        self.find_ele(self.input_box).send_keys(text)
        time.sleep(1)
        self.find_ele(self.send_btn).click()

    # 示例审校
    def review_example_knowlage_file(self):
        self.find_ele(self.book_review_btn).click()
        time.sleep(10)
        self.find_ele(self.example_btn).click()
        time.sleep(10)
        self.find_ele(self.example_knowlage_file).click()
        time.sleep(10)
        self.find_ele(self.send_btn).click()
        time.sleep(10)
        self.find_ele(self.more_find).click()
        time.sleep(10)
        self.find_ele(self.start_review_btn).click()

    def review_Content_risk_example_file(self):
        self.find_ele(self.book_review_btn).click()
        time.sleep(10)
        self.find_ele(self.example_btn).click()
        time.sleep(10)
        self.find_ele(self.example_Content_risk_file).click()
        time.sleep(10)
        self.find_ele(self.send_btn).click()
        time.sleep(10)
        self.find_ele(self.more_find).click()
        time.sleep(10)
        self.find_ele(self.start_review_btn).click()

    # 去审校记录
    def to_review_record(self):
        self.find_ele(self.review_record).click()
        time.sleep(5)
