import time

from selenium.webdriver.common.by import By

from Base.BasePage import BasePage
from common.untils import DriverTools
from config import password, user_name
from paga.AIEditingRoomPage import AIER


class Login(BasePage):
    def __init__(self):
        super().__init__('web')
        # 登录账号
        self.reader_username = (By.ID, 'userName')
        # 登录密码
        self.follow_password = (By.ID, 'pwd')
        # 登录按钮
        self.person_login = (By.XPATH, '/html/body/div/div/div/div[1]/div[3]/div/div/div[3]/form/div['
                                       '4]/div/div/div/div/button')
        # 错误弹窗
        self.login_info = (By.XPATH, '/html/body/div[2]/div/div/div/div/div/span[2]')

    def login(self, user, password):
        self.find_ele(self.reader_username).send_keys(user)
        time.sleep(1)
        self.find_ele(self.follow_password).send_keys(password)
        time.sleep(1)
        self.find_ele(self.person_login).click()
        time.sleep(1)



