
from selenium import webdriver
from appium import webdriver as appwebdriver
from selenium.webdriver.chrome.options import Options
from config import appium_server_url, caps


class DriverTools:
    __driver = None
    __app_driver = None
    __options = None

    # 初始化web驱动
    @classmethod
    def get_driver(cls):
        if cls.__driver is None:
            cls.__options = Options()
            cls.__options.add_argument('--headless')
            cls.__options.add_argument('--disable-gpu')
            cls.__options.add_argument('--no-sandbox')
            cls.__options.add_argument('--disable-dev-shm-usage')
            cls.__options.add_argument('--remote-debugging-port=9222')
            cls.__options.add_argument('--window-size=1366x768')
            cls.__driver = webdriver.Chrome(options=cls.__options)
            # cls.__driver.maximize_window()
            cls.__driver.implicitly_wait(10)
        return cls.__driver

    # 关闭web驱动
    @classmethod
    def quit_driver(cls):
        if cls.__driver:
            cls.__driver.quit()
            cls.__driver = None

    # 打开app驱动
    @classmethod
    def get_app_driver(cls):
        if cls.__app_driver is None:
            cls.__app_driver = appwebdriver.Remote(appium_server_url, caps)
            cls.__app_driver.implicitly_wait(10)
        return cls.__app_driver

    # 关闭app驱动
    @classmethod
    def quit_app_driver(cls):
        if cls.__app_driver:
            cls.__app_driver.quit()
            cls.__app_driver = None


