import time
from selenium.webdriver.common.by import By
from Base.BasePage import BasePage
from common.DButils import DButils
from common.untils import DriverTools
from paga.AIEditingRoomPage import AIER
from paga.LoginPage import Login
from common.cutils import ws_error
from config import updata_AiNewmediae_path



# AI书评编辑页面
class AIBookreview(BasePage):
    def __init__(self):
        super().__init__('web')
        # 文学书评按钮
        self.literary_btn = (By.XPATH, "(//div[@class='name'][contains(text(),'文学书评')])[1]")
        # 示例按钮
        self.example_btn = (By.XPATH, "(//div[@id='exampleButton'])[1]")
        # 发送按钮
        self.send_file = (By.XPATH, "//button[contains(text(),'发送')]")
        # 社科书评按钮
        self.social_btn = (By.XPATH, "(//div[@class='name'][contains(text(),'社科书评')])[1]")
        # 上传书稿按钮
        self.update_btn=(By.XPATH,"(//span[contains(text(),'上传书稿')])[1]")
        # 书评模板按钮
        self.template_btn = (By.XPATH, "(//span[@title='人民日报'])[1]")
        # 豆瓣书评模板
        self.bean_btn = (By.XPATH, "(//div[@class='ant-select-item-option-content'][contains(text(),'豆瓣书评')])[1]")
        # 上传书稿文件
        self.update_file = (By.XPATH, "//input[@id='file']")



    # 文学书评
    def ai_Literary(self):
        self.find_ele(self.literary_btn).click()
        time.sleep(3)
        self.find_ele(self.example_btn).click()
        time.sleep(3)
        self.find_ele(self.send_file).click()

    # 上传社科书评
    def update_social_btn(self,updata_path):
        self.find_ele(self.social_btn).click()
        time.sleep(3)
        self.find_ele(self.template_btn).click()
        time.sleep(3)
        self.find_ele(self.bean_btn).click()
        time.sleep(3)
        self.find_ele(self.update_btn).click()
        time.sleep(3)
        self.find_ele(self.update_file).send_keys(updata_path)
        time.sleep(5)
        self.find_ele(self.send_file).click()


