import time
from selenium.webdriver.common.by import By
from Base.BasePage import BasePage
from common.DButils import DButils
from common.untils import DriverTools
from paga.AIEditingRoomPage import AIER
from paga.LoginPage import Login
from common.cutils import ws_error
from config import Aiperiodicals_text



# AI数字创作编辑
class AIDigitalcreation(BasePage):
    def __init__(self):
        super().__init__('web')
        # 更多按钮
        self.more_btn = (By.XPATH, "(//div[@class='button-list-item more-btn hover-bg-color hover-text-color'])[1]")
        # 制作教辅课件类PPT按钮
        self.ppt_btn = (By.XPATH, "(//div[@class='name'][contains(text(),'制作教辅课件类PPT')])[2]")
        # 示例按钮
        self.example_btn = (By.XPATH, "(//div[@id='exampleButton'])[1]")
        # 发送按钮
        self.send_file = (By.XPATH, "//button[contains(text(),'发送')]")
        # 点击PPT确认内容按钮
        self.content_btn = (By.XPATH, "(//div[@class='fileName'])[1]")
        # 生成PPT按钮
        self.generatePPT_btn=(By.XPATH,"(//button[@type='button'])[1]")
        # 现代纸书一键制作与资源配置按钮
        self.modern_btn = (By.XPATH, "//div[contains(@class,'ant-popover button-list-more-popover ant-popover-placement-topRight')]//div[2]//div[2]//div[1]//div[1]//div[1]")
        # 书刊名称输入框
        self.periodicals_input = (By.XPATH, "(//input[@placeholder='请输入书刊名称'])[1]")
        # 点击查询按钮
        self.inquire_btn = (By.XPATH, "(//span[contains(text(),'点击查询')])[1]")
        # 点击配置资源按钮
        self.natural_btn = (By.XPATH, "(//label[@class='ant-checkbox-wrapper ant-checkbox-group-item'])[1]")
        # 点击一键制作按钮
        self.make_btn = (By.XPATH, "(//button[@class='ant-btn ant-btn-primary'])[1]")
        # 点击提供资源选题方案灵感按钮
        self.scheme_btn = (By.XPATH, "(//div[@class='name'][contains(text(),'提供资源选题方案灵感')])[2]")
        # 点击书刊分类-K12中小学教辅按钮
        self.periodicals_btn = (By.XPATH, "(//div[@class='ant-cascader-menu-item-content'][contains(text(),'K12中小学教辅')])[1]")
        # 点击书刊分类-幼小衔接按钮
        self.school_btn = (By.XPATH, "(//div[@class='ant-cascader-menu-item-content'][contains(text(),'幼小衔接')])[1]")
        # 点击书刊分类-语文按钮
        self.chinese_btn = (By.XPATH, "(//div[@class='ant-cascader-menu-item-content'][contains(text(),'语文')])[1]")
        # 点击确定按钮
        self.sure_btn = (By.XPATH, "(//span[contains(text(),'确定')])[1]")
        # 点击制作浓缩书配音按钮
        self.concentratedbook_btn = (By.XPATH, "(//div[@class='name'][contains(text(),'制作浓缩书配音')])[2]")



    # 制作教辅课件类PPT
    def ai_ppt(self):
        self.find_ele(self.more_btn).click()
        time.sleep(3)
        self.find_ele(self.ppt_btn).click()
        time.sleep(3)
        self.find_ele(self.example_btn).click()
        time.sleep(3)
        self.find_ele(self.send_file).click()
        time.sleep(30)
        self.find_ele(self.content_btn).click()
        time.sleep(3)
        self.find_ele(self.generatePPT_btn).click()


    # 现代纸书一键制作
    def modern_paper_book(self,txt):
        self.find_ele(self.more_btn).click()
        time.sleep(3)
        self.find_ele(self.modern_btn).click()
        time.sleep(3)
        self.find_ele(self.periodicals_input).send_keys(txt)
        time.sleep(3)
        self.find_ele(self.inquire_btn).click()
        time.sleep(3)
        self.find_ele(self.natural_btn).click()
        time.sleep(3)
        self.find_ele(self.make_btn).click()

    # 提供资源选题方案灵感
    def ai_scheme(self):
        self.find_ele(self.more_btn).click()
        time.sleep(3)
        self.find_ele(self.scheme_btn).click()
        time.sleep(3)
        self.find_ele(self.periodicals_btn).click()
        time.sleep(3)
        self.find_ele(self.school_btn).click()
        time.sleep(3)
        self.find_ele(self.chinese_btn).click()
        time.sleep(3)
        self.find_ele(self.sure_btn).click()
        time.sleep(3)

    # 制作浓缩书配音
    def ai_concentratedbook(self):
        self.find_ele(self.more_btn).click()
        time.sleep(3)
        self.find_ele(self.concentratedbook_btn).click()
        time.sleep(3)
        self.find_ele(self.example_btn).click()
        time.sleep(3)
        self.find_ele(self.send_file).click()
        time.sleep(3)






