import time
from selenium.webdriver.common.by import By
from Base.BasePage import BasePage
from common.DButils import DButils
from common.untils import DriverTools
from paga.AIEditingRoomPage import AIER
from paga.LoginPage import Login
from common.cutils import ws_error
from config import Aiperiodicals_text



# AI选题情报员
class AISelectedtopic(BasePage):
    def __init__(self):
        super().__init__('web')
        # 选题资讯-解读当前资讯按钮
        self.information_btn = (By.XPATH, "(//span[contains(text(),'解读当前资讯')])[1]")
        # 了解选题新鲜事按钮
        self.freshnews_btn = (By.XPATH, "(//div[contains(@class,'name')][contains(text(),'了解选题新鲜事')])[1]")
        # 示例按钮
        self.example_btn = (By.XPATH, "(//div[@id='exampleButton'])[1]")
        # 发送按钮
        self.send_file = (By.XPATH, "//button[contains(text(),'发送')]")
        # 图书榜单按钮
        self.bookrankings_file = (By.XPATH, "(//div[@id='rc-tabs-0-tab-bookRank'])[1]")
        # 解读图书榜单按钮
        self.mationbookrankings_file = (By.XPATH, "/html[1]/body[1]/div[2]/div[1]/section[1]/div[1]/div[2]/div[1]/div[1]/div[1]/div[1]/div[1]/div[1]/div[1]/div[1]/div[1]/div[1]/div[2]/div[1]/div[2]/div[1]/div[2]/div[1]/div[2]/button[1]/span[1]")


    # 选题资讯-解读当前资讯
    def ai_information(self):
        self.find_ele(self.information_btn).click()
        time.sleep(3)

    # 选题资讯-了解选题新鲜事
    def ai_freshnews(self):
        self.find_ele(self.freshnews_btn).click()
        time.sleep(5)
        self.find_ele(self.example_btn).click()
        time.sleep(3)
        self.find_ele(self.send_file).click()
        time.sleep(3)

    # 选题资讯-图书榜单按钮解读
    def ai_bookrankings(self):
        self.find_ele(self.bookrankings_file).click()
        time.sleep(5)
        self.find_ele(self.mationbookrankings_file).click()
        time.sleep(3)




