import time
from selenium.webdriver.common.by import By
from Base.BasePage import BasePage
from common.DButils import DButils
from common.untils import DriverTools
from paga.AIEditingRoomPage import AIER
from paga.LoginPage import Login
from common.cutils import ws_error
from config import Aibook_file_text



# AI选题策划编辑
class AITopicplanning(BasePage):
    def __init__(self):
        super().__init__('web')
        # 取书名按钮
        self.booktitle_btn = (By.XPATH, "(//div[@id='button-0'])[1]")
        # 写选题策划案按钮
        self.freshnews_btn = (By.XPATH, "(//div[@class='name'][contains(text(),'写选题策划案')])[1]")
        # 示例按钮
        self.example_btn = (By.XPATH, "(//div[@id='exampleButton'])[1]")
        # 发送按钮
        self.send_file = (By.XPATH, "//button[contains(text(),'发送')]")
        # 图书查询按钮
        self.book_file = (By.XPATH, "/html[1]/body[1]/div[2]/div[1]/section[1]/div[1]/div[2]/div[1]/div[1]/div[1]/div[1]/div[1]/div[1]/div[1]/div[1]/div[1]/div[1]/div[2]/div[2]/div[1]/div[1]/span[1]/span[1]/span[2]/input[1]")
        # 图书示例按钮
        self.bookexample_btn = (By.XPATH, "(//div[contains(@class,'example-button default-cursor')])[1]")
        # 搜索按钮
        self.searchfor_btn = (By.XPATH, "(//i[contains(@class,'ic ic-a-Searchtopic')])[1]")
        # 生成选题报告按钮
        self.report_btn = (By.XPATH, "(//i[contains(@class,'ic ic-yingyong')])[1]")
        # 我的模板按钮
        self.template_btn = (By.XPATH, "(//input[@value='28'])[1]")
        # 生成报告按钮
        self.reporting_btn = (By.XPATH, "(//span[contains(text(),'生成报告')])[1]")
        # 关键词按钮
        self.keyword_btn = (By.XPATH, "(//span[@title='关键词'][contains(text(),'关键词')])[1]")
        # ISBN按钮
        self.isbn_btn = (By.XPATH, "//div[contains(text(),'ISBN')]")
        # 添加至竞品分析按钮
        self.analysis_btn = (By.ID, "add-animation-508854")
        # 样式按钮
        self.style_btn = (By.XPATH, "(//i[@class='ic ic-bulletpoint'])[1]")
        # 竞品分析按钮
        self.goanalysis_btn = (By.XPATH, "(//div[@class='competitive-analysis-container-top'])[1]")
        # 对比竞品分析按钮
        self.goanalysis1_btn = (By.XPATH, "(//div[@class='compete-book-wrap'])[1]")
        # 生成竞品分析报告按钮
        self.competitiveanalysis_btn = (By.XPATH, "(//span[contains(text(),'生成竞品分析报告')])[1]")
        # 累计销量按钮
        self.Accumulated_btn = (By.XPATH, "(//*[name()='svg'])[7]")
        # 导出数据按钮
        self.exportdata_btn = (By.XPATH, "(//span[@class='export-normal'])[1]")


    # AI选题策划编辑-取书名
    def ai_booktitle(self):
        self.find_ele(self.booktitle_btn).click()
        time.sleep(3)
        self.find_ele(self.example_btn).click()
        time.sleep(3)
        self.find_ele(self.send_file).click()
        time.sleep(3)

    # AI选题策划编辑-写选题策划案
    def ai_freshnews2(self):
        self.find_ele(self.freshnews_btn).click()
        time.sleep(3)
        self.find_ele(self.example_btn).click()
        time.sleep(3)
        self.find_ele(self.send_file).click()
        time.sleep(3)

    # AI选题策划编辑-生成选题报告
    def ai_report(self,Aibook_file_text):
        self.find_ele(self.book_file).send_keys(Aibook_file_text)
        time.sleep(5)
        self.find_ele(self.searchfor_btn).click()
        time.sleep(10)
        self.find_ele(self.report_btn).click()
        time.sleep(5)
        self.find_ele(self.template_btn).click()
        time.sleep(5)
        self.find_ele(self.reporting_btn).click()
        time.sleep(5)

    #AI选题策划编辑-去竞品分析
    def ai_analysis(self,Aibook_file_text):
        self.find_ele(self.book_file).send_keys(Aibook_file_text)
        time.sleep(3)
        self.find_ele(self.searchfor_btn).click()
        time.sleep(3)
        self.find_ele(self.Accumulated_btn).click()
        time.sleep(5)
        self.find_ele(self.style_btn).click()
        time.sleep(5)
        self.find_ele(self.analysis_btn).click()
        time.sleep(3)
        self.find_ele(self.goanalysis_btn).click()
        time.sleep(5)
        self.find_ele(self.goanalysis1_btn).click()
        time.sleep(3)
        self.find_ele(self.competitiveanalysis_btn).click()
        time.sleep(3)

    # AI选题策划编辑-导出数据
    def ai_exportdata(self,Aibook_file_text):
        self.find_ele(self.book_file).send_keys(Aibook_file_text)
        time.sleep(5)
        self.find_ele(self.searchfor_btn).click()
        time.sleep(5)
        self.find_ele(self.exportdata_btn).click()
        time.sleep(3)



