import time
from selenium.webdriver.common.by import By
from Base.BasePage import BasePage
from common.DButils import DButils
from common.untils import DriverTools
from paga.AIEditingRoomPage import AIER
from paga.LoginPage import Login
from common.cutils import ws_error
from config import AiNewmediae_text,updata_AiNewmediae_path



# AI新媒体编辑页面
class AiNewmediaeditor(BasePage):
    def __init__(self):
        super().__init__('web')
        # 更多按钮
        self.more_btn = (By.XPATH, "(//div[@class='button-list-item more-btn hover-bg-color hover-text-color'])[1]")
        # 微博图书推文按钮
        self.Weibo_book = (By.XPATH, "//div[@class='button-typ-item']//div[@class='name'][contains(text(),'微博图书推文')]")
        # 示例按钮
        self.example_btn = (By.XPATH, "(//div[@id='exampleButton'])[1]")
        # 发送按钮
        self.send_file = (By.XPATH, "//button[contains(text(),'发送')]")
        # 上传书稿按钮
        self.update_btn=(By.XPATH,"(//span[contains(text(),'上传书稿')])[1]")
        # 直播间口播稿按钮
        self.broadcasting_btn = (By.XPATH, "(//div[@class='name'][contains(text(),'直播间口播稿')])[2]")
        # 书名输入
        self.title_input = (By.XPATH, "(//div[@contenteditable='true'])[2]")
        # 上传书稿文件
        self.update_file = (By.XPATH, "//input[@id='file']")



    # 微博
    def ai_Weibo(self):
        self.find_ele(self.more_btn).click()
        time.sleep(3)
        self.find_ele(self.Weibo_book).click()
        time.sleep(3)
        self.find_ele(self.example_btn).click()
        time.sleep(3)
        self.find_ele(self.send_file).click()

    # 上传直播间口播稿
    def update_ai_broadcasting(self,text,updata_path):
        self.find_ele(self.more_btn).click()
        time.sleep(3)
        self.find_ele(self.broadcasting_btn).click()
        time.sleep(3)
        self.find_ele(self.title_input).send_keys(text)
        time.sleep(3)
        self.find_ele(self.update_btn).click()
        time.sleep(3)
        self.find_ele(self.update_file).send_keys(updata_path)
        time.sleep(5)
        self.find_ele(self.send_file).click()



