import time

import allure

from common.DButils import DButils
from common.untils import DriverTools
from config import user_name, password,login_url,Aiperiodicals_text
from paga.AIEditingRoomPage import AIER
from paga.AIDigitalcreationPaga import AIDigitalcreation
from paga.LoginPage import Login
from common.cutils import ws_error

# AI数字创作编辑页面ui自动化测试
class TestaiDigitalcreation:
    # 类前置
    def setup_class(self):
        self.login = Login()
        self.AIroom = AIER()
        self.aiDigitalcreation = AIDigitalcreation()
        self.dbtuils = DButils()

    def setup_method(self):
        self.driver = DriverTools.get_driver().get(login_url)
        self.login.login(user_name, password)
        self.AIroom.to_AI_Digitalcreation()

    # 类后置
    def teardown_class(self):
        DriverTools.quit_driver()

    # AI数字创作编辑-制作教辅课件类PPT
    @allure.feature("制作教辅课件类PPT流程")
    def test_ai_ppt(self):
        self.aiDigitalcreation.ai_ppt()
        time.sleep(160)
        ws_error(1)
        time.sleep(3)

    # AI数字创作编辑-现代纸书一键制作
    @allure.feature("现代纸书一键制作流程")
    def test_modern_paper_book(self):
        self.aiDigitalcreation.modern_paper_book(Aiperiodicals_text)
        time.sleep(25)
        ws_error(1)
        time.sleep(2)

    # AI数字创作编辑-提供资源选题方案灵感
    @allure.feature("提供资源选题方案灵感流程")
    def test_ai_scheme(self):
        self.aiDigitalcreation.ai_scheme()
        time.sleep(25)
        ws_error(1)
        time.sleep(3)

    # AI数字创作编辑-制作浓缩书配音
    @allure.feature("制作浓缩书配音流程")
    def test_ai_concentratedbook(self):
        self.aiDigitalcreation.ai_concentratedbook()
        time.sleep(200)
        ws_error(1)










