import time

import allure

from common.DButils import DButils
from common.untils import DriverTools
from config import user_name, password,login_url
from paga.AIEditingRoomPage import AIER
from paga.AISelectedtopicPaga import AISelectedtopic
from paga.LoginPage import Login
from common.cutils import ws_error

# AI选题情报员页面ui自动化测试
class TestaiSelectedtopic:
    # 类前置
    def setup_class(self):
        self.login = Login()
        self.AIroom = AIER()
        self.aiselectedtopic = AISelectedtopic()
        self.dbtuils = DButils()

    def setup_method(self):
        self.driver = DriverTools.get_driver().get(login_url)
        self.login.login(user_name, password)
        self.AIroom.to_AI_Selectedtopic()

    # 类后置
    def teardown_class(self):
        DriverTools.quit_driver()

    # AI选题情报员-选题资讯-解读当前资讯
    @allure.feature("选题资讯-解读当前资讯流程")
    def test_ai_information(self):
        self.aiselectedtopic.ai_information()
        time.sleep(30)
        ws_error(1)
        time.sleep(3)

    # AI选题情报员-选题资讯-了解选题新鲜事
    @allure.feature("了解选题新鲜事流程")
    def test_ai_freshnews(self):
        self.aiselectedtopic.ai_freshnews()
        time.sleep(20)
        ws_error(1)
        time.sleep(3)

    @allure.feature("选题资讯-图书榜单按钮解读流程")
    def test_ai_bookrankings(self):
        self.aiselectedtopic.ai_bookrankings()
        time.sleep(30)
        ws_error(1)
        time.sleep(3)







