import time

import allure

from common.DButils import DButils
from common.untils import DriverTools
from config import user_name, password,login_url,Aibook_file_text
from paga.AIEditingRoomPage import AIER
from paga.AITopicplanningPaga import AITopicplanning
from paga.LoginPage import Login
from common.cutils import ws_error

# AI选题策划编辑页面ui自动化测试
class TestaiSelectedtopic:
    # 类前置
    def setup_class(self):
        self.login = Login()
        self.AIroom = AIER()
        self.aitopicplanning = AITopicplanning()
        self.dbtuils = DButils()

    def setup_method(self):
        self.driver = DriverTools.get_driver().get(login_url)
        self.login.login(user_name, password)
        self.AIroom.to_AI_Topicplanning()

    # 类后置
    def teardown_class(self):
        DriverTools.quit_driver()

    # AI选题策划编辑-取书名
    @allure.feature("取书名流程")
    def test_booktitle(self):
        self.aitopicplanning.ai_booktitle()
        time.sleep(20)
        ws_error(1)
        time.sleep(3)

    # AI选题策划编辑-写选题策划案
    @allure.feature("写选题策划案流程")
    def test_freshnews2(self):
        self.aitopicplanning.ai_freshnews2()
        time.sleep(90)
        ws_error(2)
        time.sleep(3)

    # AI选题策划编辑-生成选题报告
    @allure.feature("生成选题报告流程")
    def test_report(self):
        self.aitopicplanning.ai_report(Aibook_file_text)
        time.sleep(150)
        ws_error(1)
        time.sleep(3)

    # AI选题策划编辑-去竞品分析
    @allure.feature("去竞品分析流程")
    def test_ai_analysis(self):
        self.aitopicplanning.ai_analysis(Aibook_file_text)
        time.sleep(50)
        ws_error(1)
        time.sleep(3)

    # AI选题策划编辑-导出数据
    @allure.feature("导出数据流程")
    def test_ai_exportdata(self):
        self.aitopicplanning.ai_exportdata(Aibook_file_text)
        time.sleep(15)
        ws_error(1)
        time.sleep(3)







