import ast
import json

import requests
from common.DButils import DButils
from common.DButils_aireview import DButils_aireview

from common.DButils_dochub import DButils_dochub
from config import wechaturl, error_answer, file_path, aireview_task_url


def read_json(file_name):
    path = file_path + "/data/" + file_name
    with open(path, "r", encoding="utf-8") as f:
        data = json.load(f)
        return data


def load_json(file_name, data):
    path = file_path + "/data/" + file_name
    with open(path, "w", encoding="utf-8") as f:
        json.dump(data, f)


# 发送微信消息
def error_message(text, url=wechaturl, mobile_list=16638842134):
    data = {
        "msgtype": "text",
        "text": {
            "content": text,
            "mentioned_mobile_list": [mobile_list]
        }
    }
    requests.post(url, json=data)


# 发送mkdown格式微信消息
def mk_error_message(error_editor, error_answer, message_id, url=wechaturl):
    data = {
        "msgtype": "markdown",
        "markdown": {
            "content": f"ws推送<font color=\"warning\">异常</font>，请相关同事注意。\n>问题编辑:<font color=\"comment\">{error_editor}</font>\ncontent:<font color=\"comment\">{message_id}</font>\n>返回消息:<font color=\"comment\">{error_answer}</font> "
        }
    }
    requests.post(url, json=data)


def task_count(semantics_task_count, ideology_task_count, validate_logic_task_count, knowledge_task_count,dochub_task_count,
               url=wechaturl):
    data = {
        "msgtype": "markdown",
        "markdown": {
            "content": f"审校任务排队情况<font color=\"warning\">异常</font>，请相关同事注意。\n>语义任务:<font color=\"comment\">{semantics_task_count}</font>\n内容风险任务:<font color=\"comment\">{ideology_task_count}</font>\n逻辑检查任务:<font color=\"comment\">{validate_logic_task_count}</font>\n知识性差错任务:<font color=\"comment\">{knowledge_task_count}</font>\n文档解析批注任务:<font color=\"comment\">{dochub_task_count}</font> "
        }
    }
    requests.post(url, json=data)


# 查询ws异常消息
def ws_error(minute, error_answer_list=error_answer):
    print("开始")
    data = DButils().select_sql(
        f"select emp_id,content,id  from aicaptain.message_record mr  WHERE create_time  > NOW() - INTERVAL {minute} minute "
        f"and msg_type != 1 ; ")
    for i in range(len(data)):
        for n in error_answer_list:
            if n in data[i][1]:
                editor = DButils().select_sql(
                    f"select name from aicaptain.job where id= (SELECT job_id  FROM aicaptain.employee  WHERE "
                    f" id= {data[i][0]} ); ")
                mk_error_message(editor[0][0], n, data[i][1])
    print("结束")


def aireview_task():
    semantics_task_count = DButils_aireview().select_sql(
        "select count(*) from aireview.semantics_task where create_time >date(now()) and status = 0;")
    ideology_task_count = DButils_aireview().select_sql("select count(*) from aireview.ideology_task where "
                                                        "create_time >date(now()) and status = 0;")

    validate_logic_task_count = DButils_aireview().select_sql(
        "select count(*) from  aireview.validate_logic_task  where create_time >date(now()) and status =0;")
    knowledge_task_count = DButils_aireview().select_sql(
        "select count(*) from aireview.knowledge_task kt2  where create_time >date(now()) and status =0;")
    dochub_task_count = DButils_dochub().select_sql(
        "select count(*) from document_record where status  in (0,1) and create_time >=CURDATE();")
    if semantics_task_count[0][0] > 60000 or ideology_task_count[0][0] > 20000 or validate_logic_task_count[0][0]>20000 or knowledge_task_count[0][0]>20000 or dochub_task_count[0][0]>500:
        task_count(semantics_task_count[0][0], ideology_task_count[0][0],validate_logic_task_count[0][0],knowledge_task_count[0][0], dochub_task_count[0][0], url=aireview_task_url)

