import json

import requests
from common.DButils import DButils

from config import wechaturl, error_answer


# 发送微信消息
def error_message(text, url=wechaturl, mobile_list=16638842134):
    data = {
        "msgtype": "text",
        "text": {
            "content": text,
            "mentioned_mobile_list": [mobile_list]
        }
    }
    requests.post(url, json=data)


# 发送mkdown格式微信消息
def mk_error_message(error_editor, error_answer, message_id, url=wechaturl):
    data = {
        "msgtype": "markdown",
        "markdown": {
            "content": f"ws推送<font color=\"warning\">异常</font>，请相关同事注意。\n>问题编辑:<font color=\"comment\">{error_editor}</font>\n>消息id:<font color=\"comment\">{message_id}</font>\n>返回消息:<font color=\"comment\">{error_answer}</font> "
        }
    }
    requests.post(url, json=data)


# 查询ws异常消息
def ws_error(minute, error_answer_list=error_answer):
    print("开始")
    data = DButils().select_sql(
        f"select emp_id,content,id  from aicaptain.message_record mr  WHERE create_time  > NOW() - INTERVAL {minute} minute "
        f"and msg_type != 1 ; ")
    for i in range(len(data)):
        for n in error_answer_list:
            if n in data[i][1]:
                editor = DButils().select_sql(
                    f"select name from aicaptain.job where id= (SELECT job_id  FROM aicaptain.employee  WHERE "
                    f" id= {data[i][0]} ); ")
                mk_error_message(editor[0][0], n, data[i][2])
    print("结束")
