package com.lemon.cases;

import com.lemon.utils.AuthorizationUtils;
import io.qameta.allure.Description;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import java.util.Arrays;

public class Rays7Case extends BaseCase {

    private CookieStore token;
    private CookieStore cooki;

    // 线上环境-RAYS获取商户号支付信息
    @Test(dataProvider = "datas0")
    @Description("获取商户号支付信息")
    public void testPay(int id, String casename, String url, String json,String expectValue) throws Exception {
        String token = "430f837c00f9978dffec9d4c0c05c751";
        // 创建post请求
        HttpPost post= new HttpPost(url);
        post.setHeader("Content-Type", "application/json");
        post.setEntity(new StringEntity(json));
        DefaultHttpClient client = new DefaultHttpClient();
        // 执行get请求，并使用response来存放执行后返回的响应内容
        HttpResponse response = client.execute(post);
        Header[] header = response.getAllHeaders(); // 响应头
        System.out.println("请求链接："+url);
        System.out.println("请求参数："+json);
        System.out.print("id:" + id + "\n"+ "casename:" + casename+ "\n");
        System.out.print("响应头信息:::" + Arrays.toString(header) + "\n");
        int status = response.getStatusLine().getStatusCode();
        System.out.print("状态码:::" + status + "\n");
        HttpEntity entity = response.getEntity(); // 响应体
        String body = EntityUtils.toString(entity);
        System.out.print("预期结果: " + expectValue+ "\n");
        System.out.print("响应结果: " + body+ "\n");
        Boolean assertResponseFlag = assertRespon(expectValue, body);
        String assertContent = (assertResponseFlag) ? "Pass" : "Fail";
        System.out.print("assertContent:"+assertContent);
        Assert.assertEquals(assertContent, "Pass");
    }

    @DataProvider(name = "datas0")
    public Object[][] datas0() {
        //Object[m][n] m代表执行次数，n代表参数个数
        Object[][] datas = {
//                {1, "旅游攻略", "http://192.168.92.212:8272/aimarket/v1.0/aiserve/createServe", "{\"serviceName\":\"旅游攻略\",\"serveAppSecret\":\"430f837c00f9978dffec9d4c0c05c751\",\"serveToken\":\"430f837c00f9978dffec9d4c0c05c751\",\"encodingAESKey\":\"430f837c00f9978dffec9d4c0c05c751\",\"serviceType\":2,\"prompt\":\"我要你扮演成导游，给我介绍当地的景点、美食以及旅游攻略。我的第一个请求是“我需要了解武汉的旅游攻略\",\"createUser\":1,\"isSyncData\":0,\"notifyUrl\":\"https://raysgo.com/raysserve/v1.0/serveDispatch/handleServe\"}","{\"errCode\":90040013,\"message\":\"服务名称已存在\"}"},
//                {2, "为你写诗", "http://192.168.92.212:8272/aimarket/v1.0/aiserve/createServe", "{\"serviceName\":\"为你写诗\",\"serveAppSecret\":\"430f837c00f9978dffec9d4c0c05c751\",\"serveToken\":\"430f837c00f9978dffec9d4c0c05c751\",\"encodingAESKey\":\"430f837c00f9978dffec9d4c0c05c751\",\"serviceType\":2,\"prompt\":\"我要你扮演诗人。你将创作出能唤起情感并具有触动人心的力量的诗歌。写任何主题或主题，但要确保您的文字以优美而有意义的方式传达您试图表达的感觉。您还可以想出一些短小的诗句，这些诗句仍然足够强大，可以在读者的脑海中留下印记。我的第一个请求是“我需要一首关于爱情的诗\",\"createUser\":1,\"isSyncData\":0,\"notifyUrl\":\"https://raysgo.com/raysserve/v1.0/serveDispatch/handleServe\"}","{\"errCode\":90040013,\"message\":\"服务名称已存在\"}"}, // RAYS跳RAYS
        };
        return datas;
    }
}
