package com.lemon.cases;

import com.alibaba.fastjson.JSONObject;
import com.lemon.constants.Constants;
import com.lemon.pojo.API;
import com.lemon.pojo.Case;
import com.lemon.utils.AuthorizationUtils;
import com.lemon.utils.ExcelUtils;
import com.lemon.utils.HttpUtils;
import com.lemon.utils.SqlUtils;
import netscape.javascript.JSObject;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.List;
import java.util.Set;

/**
 * @program: Lemon
 * @description:
 * @author: ray
 * @create: 2022-11-03 13:57
 **/
public class RegisterDemoCase extends BaseCase {

    @Test(dataProvider = "datas1")   // DTO数据传输
    public void testRegister(API api, Case cas) throws Exception {
        //1、参数化替换
        String params = replace(cas.getParams());
        String sql = replace(cas.getCheckSQL());
        cas.setParams(params);
        cas.setCheckSQL(sql);
        //2、数据库前置查询结果（断言必须在接口执行前后都查询）
        Object beforeSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //3、调用接口
        String body = call(api, cas, false);
        //4、断言响应结果，Excel中预期响应数据与实际响应数据进行对比
        boolean assertResponseFlag = assertResponse(cas, body);
        //5、添加接口响应回写excel内容
        addWBD(Integer.parseInt(cas.getId()), Constants.ACTURL_WRITER_BACK_CELL_NUM, body);
        //6、数据库后置查询结果
        Object afterSqlResult = SqlUtils.querySingle(cas.getCheckSQL());
        //7、数据库断言
        boolean sqlFlag = sqlAssert(cas, beforeSqlResult, afterSqlResult);
        System.out.println("数据库断言结果：" + sqlFlag);
        //8、添加断言回写内容
        String assertContent = (assertResponseFlag && sqlFlag) ? "Pass" : "Fail";
        addWBD(Integer.parseInt(cas.getId()), Constants.ASSERT_RESULT_CELL_NUM, assertContent);
        //9、添加日志

        //10、报表断言
        Assert.assertEquals(assertContent, "Pass");

    }

    /**
     * 注册数据库断言方法
     *
     * @param beforeSqlResult
     * @param afterSqlResult
     * @return
     */
    public boolean sqlAssert(Case cas, Object beforeSqlResult, Object afterSqlResult) {
        String sql = cas.getCheckSQL();
        //如果sql为空，说明不需要数据库断言
        if (StringUtils.isBlank(sql)) {
            return true;
        } else {
            //注册断言逻辑：前置sql结果为0，后置sql结果为1，其他情况断言失败
            long beforeValue = (long) beforeSqlResult;
            long afterValue = (long) afterSqlResult;
            System.out.println("sql:" + sql);
            System.out.println("beforeValue:" + beforeValue);
            System.out.println("afterValue:" + afterValue);
            if (beforeValue == 0 && afterValue == 1) {
                return true;
            } else {
                return false;
            }
        }
    }


    @DataProvider(name = "datas0")
    public Object[][] datas0() {
        //Object[m][n] m代表执行次数，n代表参数个数
        Object[][] datas = {
                {"http://api.lemonban.com/fetureloan/member/register", "{\"mobile_phone\":\"15500110011\",\"pwd\":\"123456\"}"},
                {"http://api.lemonban.com/fetureloan/member/register", "{\"mobile_phone\":\"15500110012\",\"pwd\":\"123456\"}"},
                {"http://api.lemonban.com/fetureloan/member/register", "{\"mobile_phone\":\"15500110013\",\"pwd\":\"123456\"}"},
        };
        return datas;
    }


    @DataProvider(name = "datas1")
    public Object[][] datas1() {
        Object[][] datas = ExcelUtils.getAPIAndCaseByApiId("1");
        return datas;
    }


}
