package com.lemon.httpclient;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.util.Arrays;

/**
 * @program: Lemon
 * @description:
 * @author: ray
 * @create: 2022-09-23 12:54
 **/
public class PostDemo2 {
    public static void main(String[] args) throws Exception {
        // 1、2、3
        HttpPost httpPost = new HttpPost("http://api.lemonban.com/fetureloan/login");
        // 4、有参传参、有头加头
        httpPost.setHeader("X-Lemonban-Media-Type", "lemonban.v1");
        // Post请求必须添加content-type
        httpPost.setHeader("Content-Type", "application/x-www-from-urlencoded;charset=UTF-8");
        // 传参
        httpPost.setEntity(new StringEntity("username=15500220022&password=123456"));
        // 5、点击发送按钮
        CloseableHttpClient httpClient = HttpClients.createDefault();
        // 6、接收响应
        CloseableHttpResponse response = httpClient.execute(httpPost);
        // 获取body
        HttpEntity entity = response.getEntity();
        // 获取状态码
        int statusCode = response.getStatusLine().getStatusCode();
        // 获取header
        Header[] headers = response.getAllHeaders();

        System.out.println(EntityUtils.toString(entity));
        System.out.println(statusCode);
        System.out.println(Arrays.toString(headers));
    }
}
