package com.lemon.json;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.File;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;

/**
 * @program: Lemon
 * @description:
 * @author: ray
 * @create: 2022-09-22 14:47
 **/
public class Dom4jDemo {
    /*
     * 1、添加依赖：dom4j
     * 2、创建解析器SAXReader对象
     * 3、获取document对象
     * 4、获取根元素
     * 5、获取根元素的子元素
     * */
    public static void main(String[] args) throws DocumentException {
        // 创建saxReader对象
        SAXReader reader = new SAXReader();
        // 通过read方法读取一个文件,转换成Document对象
        Document document = reader.read(new File("src/test1.xml"));
        // 获取根元素
        Element rootElement = document.getRootElement();
        // 获取根元素下所有子元素
        List<Element> elements = rootElement.elements();
        for (Element element : elements) {
            // 根元素下的一级子元素
            Object data = element.getData();
            System.out.println("标签名称:" + element.getName() + "+标签内容:" + data);
        }


    }
}
