package com.lemon.testng;

import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;


import java.io.IOException;
import java.util.Arrays;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

/**
 * @program: Lemon
 * @description:
 * @author: ray
 * @create: 2022-09-22 16:45
 **/
public class TestNGDataProvider {

    @Test(dataProvider = "da")
    public void testLoginOne(String JsonStr) throws Exception {
        String url = "https://ra.raysyun.com";
        HttpPost post = new HttpPost(url + "/usercenter/v1.0/user/login");
        post.setHeader("Content-Type", "application/json");
        post.setEntity(new StringEntity(JsonStr, "utf-8"));
        HttpClient client = HttpClients.createDefault();
        HttpResponse res = client.execute(post);
        Header[] header = res.getAllHeaders(); // 响应头
        System.out.print("响应头信息：" + Arrays.toString(header) + "\n");
        int status = res.getStatusLine().getStatusCode();
        System.out.print("状态码：：" + status + "\n");
        HttpEntity entity = res.getEntity(); // 响应体
        String body = EntityUtils.toString(entity);
        System.out.print("响应体信息：" + body);
    }

    @DataProvider(name = "da")
    public Object[][] da() {
        Object[][] da = {
                {"{\"userName\":\"15927555348\",\"pwd\":\"5ec0b6355d9a5fdb2996c5b9950cc1c6\",\"isRemember\":1,\"systemCode\":\"agent\"}"},
                {"{\"userName\":\"15927555348\",\"pwd\":\"5ec0b6355d9a5fdb2996c5b9950cc1c0\",\"isRemember\":1,\"systemCode\":\"agent\"}"},
                {"{\"userName\":\"15927555340\",\"pwd\":\"5ec0b6355d9a5fdb2996c5b9950cc1c6\",\"isRemember\":1,\"systemCode\":\"agent\"}"},
        };
        return da;
    }


    @Test(dataProvider = "datas")
    public void testLogin5(String username, String password) {
        System.out.println(username + ":" + password);
    }

    @DataProvider(name = "datas")
    public Object[][] datas() {
//        Object[][] datas = new Object[1][2];
        Object[][] datas = {
                {"zhangsan", "123"},
                {"wangsans", "456"},
                {"zhangpin", "789"},
        };
        return datas;
    }

}


